/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.prettifier;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.PathStepStringifier;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.MultiRelationshipPathStep;
import org.neo4j.cypher.internal.expressions.NilPathStep;
import org.neo4j.cypher.internal.expressions.NodePathStep;
import org.neo4j.cypher.internal.expressions.NodeRelPair;
import org.neo4j.cypher.internal.expressions.PathStep;
import org.neo4j.cypher.internal.expressions.RepeatPathStep;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.SingleRelationshipPathStep;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000554AAB\u0004\u0005)!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003$\u0001\u0011\u0005A\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003=\u0001\u0011%Q\bC\u0003\\\u0001\u0011%AL\u0001\u000eEK\u001a\fW\u000f\u001c;QCRD7\u000b^3q'R\u0014\u0018N\\4jM&,'O\u0003\u0002\t\u0013\u0005Q\u0001O]3ui&4\u0017.\u001a:\u000b\u0005)Y\u0011aA1ti*\u0011A\"D\u0001\tS:$XM\u001d8bY*\u0011abD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005A\t\u0012!\u00028f_RR'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011aB\u0005\u0003=\u001d\u00111\u0003U1uQN#X\r]*ue&tw-\u001b4jKJ\fA!\u001a=qeB\u0011A$I\u0005\u0003E\u001d\u0011Q#\u0012=qe\u0016\u001c8/[8o'R\u0014\u0018N\\4jM&,'/\u0001\u0004=S:LGO\u0010\u000b\u0003K\u0019\u0002\"\u0001\b\u0001\t\u000b}\u0011\u0001\u0019\u0001\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005%\"\u0004C\u0001\u00162\u001d\tYs\u0006\u0005\u0002-/5\tQF\u0003\u0002/'\u00051AH]8pizJ!\u0001M\f\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a]AQ!N\u0002A\u0002Y\n\u0001\u0002]1uQN#X\r\u001d\t\u0003oij\u0011\u0001\u000f\u0006\u0003s-\t1\"\u001a=qe\u0016\u001c8/[8og&\u00111\b\u000f\u0002\t!\u0006$\bn\u0015;fa\u0006!\"/\u001a7bi&|gn\u001d5jaB\u000bG\u000f[*uKB$bAP#K\u001fR3\u0006CA E\u001b\u0005\u0001%BA!C\u0003\u0011a\u0017M\\4\u000b\u0003\r\u000bAA[1wC&\u0011!\u0007\u0011\u0005\u0006\r\u0012\u0001\raR\u0001\u0004e\u0016d\u0007CA\u001cI\u0013\tI\u0005HA\bM_\u001eL7-\u00197WCJL\u0017M\u00197f\u0011\u0015YE\u00011\u0001M\u0003%!\u0017N]3di&|g\u000e\u0005\u00028\u001b&\u0011a\n\u000f\u0002\u0012'\u0016l\u0017M\u001c;jG\u0012K'/Z2uS>t\u0007\"\u0002)\u0005\u0001\u0004\t\u0016A\u0002;p\u001d>$W\rE\u0002\u0017%\u001eK!aU\f\u0003\r=\u0003H/[8o\u0011\u0015)F\u00011\u00017\u0003\u0011qW\r\u001f;\t\u000b]#\u0001\u0019\u0001-\u0002\u0015%\u001cX*\u001e7uSJ+G\u000e\u0005\u0002\u00173&\u0011!l\u0006\u0002\b\u0005>|G.Z1o\u00039\u0011X\r]3biB\u000bG\u000f[*uKB$B!K/lY\")a,\u0002a\u0001?\u0006Ia/\u0019:jC\ndWm\u001d\t\u0004A\u0016DgBA1d\u001d\ta#-C\u0001\u0019\u0013\t!w#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0019<'aA*fc*\u0011Am\u0006\t\u0003o%L!A\u001b\u001d\u0003\u00179{G-\u001a*fYB\u000b\u0017N\u001d\u0005\u0006!\u0016\u0001\ra\u0012\u0005\u0006+\u0016\u0001\rA\u000e")
public class DefaultPathStepStringifier
implements PathStepStringifier {
    private final ExpressionStringifier expr;

    @Override
    public String apply(PathStep pathStep) {
        PathStep pathStep2 = pathStep;
        if (pathStep2 instanceof SingleRelationshipPathStep) {
            SingleRelationshipPathStep singleRelationshipPathStep = (SingleRelationshipPathStep)pathStep2;
            LogicalVariable rel = singleRelationshipPathStep.rel();
            SemanticDirection direction = singleRelationshipPathStep.direction();
            Option toNode = singleRelationshipPathStep.toNode();
            PathStep next = singleRelationshipPathStep.next();
            return this.relationshipPathStep(rel, direction, (Option<LogicalVariable>)toNode, next, false);
        }
        if (pathStep2 instanceof NodePathStep) {
            NodePathStep nodePathStep = (NodePathStep)pathStep2;
            LogicalVariable node = nodePathStep.node();
            PathStep next = nodePathStep.next();
            return "(" + this.expr.apply((Expression)node) + ")" + this.apply(next);
        }
        if (pathStep2 instanceof MultiRelationshipPathStep) {
            MultiRelationshipPathStep multiRelationshipPathStep = (MultiRelationshipPathStep)pathStep2;
            LogicalVariable rel = multiRelationshipPathStep.rel();
            SemanticDirection direction = multiRelationshipPathStep.direction();
            Option toNode = multiRelationshipPathStep.toNode();
            PathStep next = multiRelationshipPathStep.next();
            return this.relationshipPathStep(rel, direction, (Option<LogicalVariable>)toNode, next, true);
        }
        if (pathStep2 instanceof RepeatPathStep) {
            RepeatPathStep repeatPathStep = (RepeatPathStep)pathStep2;
            Seq variables = repeatPathStep.variables();
            LogicalVariable toNode = repeatPathStep.toNode();
            PathStep next = repeatPathStep.next();
            return this.repeatPathStep((Seq<NodeRelPair>)variables, toNode, next);
        }
        if (pathStep2 instanceof NilPathStep) {
            return "";
        }
        throw new MatchError((Object)pathStep2);
    }

    private String relationshipPathStep(LogicalVariable rel, SemanticDirection direction, Option<LogicalVariable> toNode, PathStep next, boolean isMultiRel) {
        SemanticDirection semanticDirection = direction;
        SemanticDirection.INCOMING$ iNCOMING$ = SemanticDirection.INCOMING$.MODULE$;
        String lArrow = !(semanticDirection != null ? !semanticDirection.equals(iNCOMING$) : iNCOMING$ != null) ? "<" : "";
        SemanticDirection semanticDirection2 = direction;
        SemanticDirection.OUTGOING$ oUTGOING$ = SemanticDirection.OUTGOING$.MODULE$;
        String rArrow = !(semanticDirection2 != null ? !semanticDirection2.equals(oUTGOING$) : oUTGOING$ != null) ? ">" : "";
        String stringifiedToNode = (String)toNode.map((Function1 & Serializable)x$1 -> $this.expr.apply((Expression)x$1)).getOrElse((Function0 & Serializable)() -> "");
        String stringifiedRel = this.expr.apply((Expression)rel);
        String multiRel = isMultiRel ? "*" : "";
        return lArrow + "-[" + stringifiedRel + multiRel + "]-" + rArrow + "(" + stringifiedToNode + ")" + this.apply(next);
    }

    private String repeatPathStep(Seq<NodeRelPair> variables, LogicalVariable toNode, PathStep next) {
        String variableString = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)variables.flatMap((Function1 & Serializable)x$2 -> x$2.variables())).map((Function1 & Serializable)x$3 -> x$3.name())).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (index % 2 == 0) {
                    return "(" + name + ")";
                }
            }
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                return "-[" + name + "]-";
            }
            throw new MatchError((Object)tuple2);
        })).mkString("");
        return " (" + variableString + "())* (" + toNode.name() + ")" + this.apply(next);
    }

    public DefaultPathStepStringifier(ExpressionStringifier expr) {
        this.expr = expr;
    }
}

