/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.neo4j.cloud.storage.PathRepresentation;
import org.neo4j.cloud.storage.StorageSystem;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.util.Preconditions;

public class StoragePath
implements Path {
    private final StorageSystem storage;
    private final PathRepresentation path;
    private final Map<String, Object> metadata;

    private StoragePath(StorageSystem storage, PathRepresentation path, Map<String, Object> metadata) {
        this.storage = Objects.requireNonNull(storage);
        this.path = Objects.requireNonNull(path);
        this.metadata = Objects.requireNonNull(metadata);
    }

    StoragePath(StorageSystem storage, PathRepresentation path) {
        this(storage, path, (Map<String, Object>)Maps.mutable.empty());
    }

    public static boolean isRoot(StoragePath storagePath) {
        return storagePath.path.isRoot();
    }

    public static boolean isStorageDir(Path path) {
        StoragePath storagePath;
        return path instanceof StoragePath && (storagePath = (StoragePath)path).isDirectory();
    }

    public static boolean isEmpty(StoragePath storagePath) {
        return Objects.equals(storagePath.path, PathRepresentation.EMPTY_PATH);
    }

    public String scheme() {
        return this.storage.scheme();
    }

    public boolean isDirectory() {
        return this.path.isDirectory();
    }

    public ImmutableMap<String, Object> metadata() {
        return Maps.immutable.ofMap(this.metadata);
    }

    public StoragePath addMetadata(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    public StoragePath copy() {
        return new StoragePath(this.storage, this.path, (Map<String, Object>)Maps.mutable.withMap(this.metadata));
    }

    @Override
    public StorageSystem getFileSystem() {
        return this.storage;
    }

    @Override
    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    @Override
    public StoragePath getRoot() {
        return this.isAbsolute() ? new StoragePath(this.storage, PathRepresentation.ROOT) : null;
    }

    @Override
    public StoragePath getFileName() {
        if (this.path.isRoot() || PathRepresentation.EMPTY_PATH.equals(this.path)) {
            return null;
        }
        List<String> elements = this.path.elements();
        if (this.path.hasTrailingSeparator()) {
            return this.from(StoragePath.last(elements) + "/", new String[0]);
        }
        return this.from(StoragePath.last(elements), new String[0]);
    }

    @Override
    public StoragePath getParent() {
        PathRepresentation parent = this.path.getParent();
        return parent == null ? null : new StoragePath(this.storage, parent);
    }

    @Override
    public int getNameCount() {
        return this.path.elements().size();
    }

    @Override
    public StoragePath getName(int index) {
        return this.subpath(index, index + 1);
    }

    @Override
    public StoragePath subpath(int beginIndex, int endIndex) {
        return new StoragePath(this.storage, this.path.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (!this.storage.equals(other.getFileSystem())) {
            return false;
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            return false;
        }
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (other instanceof StoragePath) {
            StoragePath sp = (StoragePath)other;
            return this.path.equals(sp.path) || this.path.length() >= sp.path.length() && StoragePath.checkPrefixedParts(StoragePath.split(this.path, false), StoragePath.split(sp.path, false));
        }
        return false;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.from(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        if (!this.storage.equals(other.getFileSystem())) {
            return false;
        }
        if (other.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        if (other.getNameCount() > this.getNameCount()) {
            return false;
        }
        if (other instanceof StoragePath) {
            StoragePath sp = (StoragePath)other;
            return this.path.equals(sp.path) || this.path.length() >= sp.path.length() && this.path.hasTrailingSeparator() == sp.path.hasTrailingSeparator() && StoragePath.checkPrefixedParts(StoragePath.split(this.path, true), StoragePath.split(sp.path, true));
        }
        return false;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.from(other, new String[0]));
    }

    @Override
    public StoragePath normalize() {
        if (this.path.isRoot()) {
            return this;
        }
        List<String> elements = this.path.elements();
        ArrayDeque<String> normalized = new ArrayDeque<String>(elements.size());
        for (String element : elements) {
            if (element.equals(".")) continue;
            if (element.equals("..")) {
                normalized.pollLast();
                continue;
            }
            normalized.addLast(element);
        }
        StringBuilder parts = new StringBuilder(String.join((CharSequence)"/", normalized));
        if (this.path.isAbsolute()) {
            parts.insert(0, "/");
        }
        if (this.path.hasTrailingSeparator() || !Objects.equals(StoragePath.last(elements), normalized.peekLast())) {
            parts.append("/");
        }
        return this.from(parts.toString(), new String[0]);
    }

    @Override
    public StoragePath resolve(Path other) {
        StoragePath storagePath = StoragePath.ensureStoragePath(other);
        if (storagePath.isAbsolute()) {
            return storagePath;
        }
        if (storagePath.path.equals(PathRepresentation.EMPTY_PATH)) {
            return this;
        }
        if (this.storage.canResolve(storagePath)) {
            String resolvedPath = !this.path.hasTrailingSeparator() ? this + "/" + storagePath : this.toString() + storagePath;
            return this.from(resolvedPath, new String[0]);
        }
        throw new ProviderMismatchException("A storage path can only resolve another storage path within the same storage system");
    }

    @Override
    public StoragePath resolve(String other) {
        return this.resolve(this.from(other, new String[0]));
    }

    @Override
    public StoragePath resolveSibling(String other) {
        return this.getParent().resolve(other);
    }

    @Override
    public StoragePath resolveSibling(Path other) {
        return this.getParent().resolve(other);
    }

    @Override
    public StoragePath relativize(Path other) {
        int parentDirCount;
        StoragePath otherPath = StoragePath.ensureStoragePath(other);
        if (this.equals(otherPath)) {
            return new StoragePath(this.storage, PathRepresentation.EMPTY_PATH);
        }
        if (!this.storage.canResolve(otherPath)) {
            throw new ProviderMismatchException("A storage path can only relativize another storage path within the same storage system");
        }
        Preconditions.checkArgument((this.isAbsolute() == other.isAbsolute() ? 1 : 0) != 0, (String)"to obtain a relative path both must be absolute or both must be relative");
        if (this.path.equals(PathRepresentation.EMPTY_PATH)) {
            return otherPath;
        }
        int nameCount = this.getNameCount();
        int otherNameCount = other.getNameCount();
        int limit = Math.min(nameCount, otherNameCount);
        int differenceCount = this.getDifferenceCount(otherPath, limit);
        if (differenceCount < otherNameCount) {
            return this.getRelativePathFromDifference(otherPath, otherNameCount, differenceCount, parentDirCount);
        }
        char[] relativePath = new char[parentDirCount * 3 - 1];
        int index = 0;
        for (parentDirCount = nameCount - differenceCount; parentDirCount > 0; --parentDirCount) {
            relativePath[index++] = PathRepresentation.CURRENT_DIR_CHAR;
            relativePath[index++] = PathRepresentation.CURRENT_DIR_CHAR;
            if (parentDirCount <= 1) continue;
            relativePath[index++] = PathRepresentation.PATH_SEPARATOR_CHAR;
        }
        return new StoragePath(this.storage, PathRepresentation.of(relativePath));
    }

    @Override
    public URI toUri() {
        StringBuilder uri = new StringBuilder(this.getFileSystem().uriPrefix()).append("/");
        for (Path step : this.toAbsolutePath().toRealPath(LinkOption.NOFOLLOW_LINKS)) {
            String name = step.getFileName().toString();
            boolean isDir = name.endsWith("/");
            if (isDir) {
                name = name.substring(0, name.length() - 1);
            }
            uri.append(URLEncoder.encode(name, StandardCharsets.UTF_8));
            if (!isDir) continue;
            uri.append("/");
        }
        return URI.create(uri.toString());
    }

    @Override
    public StoragePath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return new StoragePath(this.storage, PathRepresentation.of("/", this.path.toString()));
    }

    @Override
    public StoragePath toRealPath(LinkOption ... options) {
        StoragePath p = this.isAbsolute() ? this : this.toAbsolutePath();
        return this.from("/", p.normalize().toString());
    }

    @Override
    public int compareTo(Path other) {
        StoragePath storagePath = StoragePath.ensureStoragePath(other);
        if (storagePath.storage != this.storage) {
            throw new ClassCastException("compared storage paths must be from the same storage system");
        }
        return this.toRealPath(LinkOption.NOFOLLOW_LINKS).toString().compareTo(storagePath.toRealPath(LinkOption.NOFOLLOW_LINKS).toString());
    }

    @Override
    public Iterator<Path> iterator() {
        return new StoragePathIterator(this.path.elements().iterator(), this.path.isAbsolute(), this.path.hasTrailingSeparator());
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("Storage paths cannot be converted to File objects");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException("register");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) {
        throw new UnsupportedOperationException("register");
    }

    @Override
    public String toString() {
        return this.path.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoragePath that = (StoragePath)o;
        return this.storage.equals(that.storage) && this.path.equals(that.path) && this.metadata.equals(that.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.storage, this.path, this.metadata);
    }

    private StoragePath getRelativePathFromDifference(StoragePath otherPath, int otherNameCount, int differenceCount, int parentDirCount) {
        Objects.requireNonNull(otherPath);
        StoragePath remainingSubPath = otherPath.subpath(differenceCount, otherNameCount);
        if (parentDirCount == 0) {
            return remainingSubPath;
        }
        int relativePathSize = parentDirCount * 3 + remainingSubPath.path.toString().length();
        if (otherPath.path.equals(PathRepresentation.EMPTY_PATH)) {
            --relativePathSize;
        }
        char[] relativePath = new char[relativePathSize];
        int index = 0;
        while (parentDirCount > 0) {
            relativePath[index++] = PathRepresentation.CURRENT_DIR_CHAR;
            relativePath[index++] = PathRepresentation.CURRENT_DIR_CHAR;
            if (otherPath.path.equals(PathRepresentation.EMPTY_PATH)) {
                if (parentDirCount > 1) {
                    relativePath[index++] = PathRepresentation.PATH_SEPARATOR_CHAR;
                }
            } else {
                relativePath[index++] = PathRepresentation.PATH_SEPARATOR_CHAR;
            }
            --parentDirCount;
        }
        System.arraycopy(remainingSubPath.path.chars(), 0, relativePath, index, remainingSubPath.path.chars().length);
        return new StoragePath(this.storage, PathRepresentation.of(relativePath));
    }

    private int getDifferenceCount(StoragePath other, int limit) {
        int i;
        for (i = 0; i < limit && Objects.equals(this.getName(i), other.getName(i)); ++i) {
        }
        return i;
    }

    private StoragePath from(String first, String ... more) {
        return new StoragePath(this.storage, PathRepresentation.of(first, more));
    }

    private static StoragePath ensureStoragePath(Path other) {
        if (other instanceof StoragePath) {
            StoragePath path = (StoragePath)other;
            return path;
        }
        throw new ProviderMismatchException("Path provided is not a StoragePath: " + other);
    }

    private static Iterator<String> split(PathRepresentation path, boolean reversed) {
        List<String> elements = path.elements();
        return reversed ? Iterables.reverse(elements).iterator() : elements.iterator();
    }

    private static boolean checkPrefixedParts(Iterator<String> theMatches, Iterator<String> toMatch) {
        while (toMatch.hasNext()) {
            if (theMatches.hasNext() && theMatches.next().equals(toMatch.next())) continue;
            return false;
        }
        return true;
    }

    private static String last(List<String> items) {
        return items.isEmpty() ? null : items.get(items.size() - 1);
    }

    private class StoragePathIterator
    implements Iterator<Path> {
        private final Iterator<String> delegate;
        private final boolean isAbsolute;
        private final boolean hasTrailingSeparator;
        private boolean first;

        private StoragePathIterator(Iterator<String> delegate, boolean isAbsolute, boolean hasTrailingSeparator) {
            this.delegate = delegate;
            this.isAbsolute = isAbsolute;
            this.hasTrailingSeparator = hasTrailingSeparator;
            this.first = true;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public StoragePath next() {
            Object pathString = this.delegate.next();
            if (this.isAbsolute && this.first) {
                this.first = false;
                pathString = "/" + (String)pathString;
                if (!this.hasNext() && this.hasTrailingSeparator) {
                    pathString = (String)pathString + "/";
                }
            }
            if (this.hasNext() || this.hasTrailingSeparator) {
                pathString = (String)pathString + "/";
            }
            return StoragePath.this.from((String)pathString, new String[0]);
        }
    }
}

