/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.DynamicSizeUtil;
import org.neo4j.index.internal.gbptree.GBPTreeGenerationTarget;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.OffloadStore;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.context.CursorContext;

public final class TreeNodeUtil {
    static final int BYTE_POS_NODE_TYPE = 0;
    static final int SIZE_PAGE_REFERENCE = 24;
    static final int BYTE_POS_TYPE = 1;
    static final int BYTE_POS_GENERATION = 2;
    static final int BYTE_POS_KEYCOUNT = 6;
    static final int BYTE_POS_RIGHTSIBLING = 10;
    static final int BYTE_POS_LEFTSIBLING = 34;
    static final int BYTE_POS_SUCCESSOR = 58;
    static final int BASE_HEADER_LENGTH = 82;
    static final byte NODE_TYPE_TREE_NODE = 1;
    static final byte NODE_TYPE_FREE_LIST_NODE = 2;
    static final byte NODE_TYPE_OFFLOAD = 3;
    static final byte LEAF_FLAG = 1;
    static final byte INTERNAL_FLAG = 0;
    public static final byte DATA_LAYER_FLAG = 0;
    static final byte ROOT_LAYER_FLAG = 1;
    static final long NO_NODE_FLAG = 0L;
    static final long NO_OFFLOAD_ID = -1L;
    static final int NO_KEY_VALUE_SIZE_CAP = -1;
    private static final int LAYER_TYPE_SHIFT = 4;
    private static final int TREE_NODE_MASK = 15;
    private static final int LAYER_TYPE_MASK = 15;

    static int splitPos(int keyCount, double ratioToKeepInLeftOnSplit) {
        int minSplitPos = 1;
        int maxSplitPos = keyCount - 1;
        return Math.max(minSplitPos, Math.min(maxSplitPos, (int)(ratioToKeepInLeftOnSplit * (double)keyCount)));
    }

    static byte nodeType(PageCursor cursor) {
        return cursor.getByte(0);
    }

    static void writeBaseHeader(PageCursor cursor, byte type, byte layerType, long stableGeneration, long unstableGeneration) {
        cursor.putByte(0, (byte)1);
        cursor.putByte(1, TreeNodeUtil.buildTypeByte(type, layerType));
        TreeNodeUtil.setGeneration(cursor, unstableGeneration);
        TreeNodeUtil.setKeyCount(cursor, 0);
        TreeNodeUtil.setRightSibling(cursor, 0L, stableGeneration, unstableGeneration);
        TreeNodeUtil.setLeftSibling(cursor, 0L, stableGeneration, unstableGeneration);
        TreeNodeUtil.setSuccessor(cursor, 0L, stableGeneration, unstableGeneration);
    }

    private static byte buildTypeByte(byte type, byte layerType) {
        return (byte)(type | layerType << 4);
    }

    static byte treeNodeType(PageCursor cursor) {
        return (byte)(cursor.getByte(1) & 0xF);
    }

    static byte layerType(PageCursor cursor) {
        return (byte)(cursor.getByte(1) >>> 4 & 0xF);
    }

    public static boolean isLeaf(PageCursor cursor) {
        return TreeNodeUtil.treeNodeType(cursor) == 1;
    }

    static boolean isInternal(PageCursor cursor) {
        return TreeNodeUtil.treeNodeType(cursor) == 0;
    }

    static long generation(PageCursor cursor) {
        return (long)cursor.getInt(2) & 0xFFFFFFFFL;
    }

    public static int keyCount(PageCursor cursor) {
        return cursor.getInt(6);
    }

    public static long rightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        return TreeNodeUtil.rightSibling(cursor, stableGeneration, unstableGeneration, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    static long rightSibling(PageCursor cursor, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        cursor.setOffset(10);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, generationTarget);
    }

    static long leftSibling(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        return TreeNodeUtil.leftSibling(cursor, stableGeneration, unstableGeneration, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    static long leftSibling(PageCursor cursor, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        cursor.setOffset(34);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, generationTarget);
    }

    static long successor(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        return TreeNodeUtil.successor(cursor, stableGeneration, unstableGeneration, GBPTreeGenerationTarget.NO_GENERATION_TARGET);
    }

    static long successor(PageCursor cursor, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        cursor.setOffset(58);
        return GenerationSafePointerPair.read(cursor, stableGeneration, unstableGeneration, generationTarget);
    }

    static void setGeneration(PageCursor cursor, long generation) {
        GenerationSafePointer.assertGenerationOnWrite(generation);
        cursor.putInt(2, (int)generation);
    }

    public static void setKeyCount(PageCursor cursor, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Invalid key count, " + count + ". On tree node " + cursor.getCurrentPageId() + ".");
        }
        cursor.putInt(6, count);
    }

    static void setRightSibling(PageCursor cursor, long rightSiblingId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(10);
        long result = GenerationSafePointerPair.write(cursor, rightSiblingId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result, cursor.getCurrentPageId(), "RIGHT_SIBLING", stableGeneration, unstableGeneration, cursor, 10);
    }

    static void setLeftSibling(PageCursor cursor, long leftSiblingId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(34);
        long result = GenerationSafePointerPair.write(cursor, leftSiblingId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result, cursor.getCurrentPageId(), "LEFT_SIBLING", stableGeneration, unstableGeneration, cursor, 34);
    }

    static void setSuccessor(PageCursor cursor, long successorId, long stableGeneration, long unstableGeneration) {
        cursor.setOffset(58);
        long result = GenerationSafePointerPair.write(cursor, successorId, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(result, cursor.getCurrentPageId(), "SUCCESSOR", stableGeneration, unstableGeneration, cursor, 58);
    }

    static void insertSlotsAt(PageCursor cursor, int pos, int numberOfSlots, int totalSlotCount, int baseOffset, int slotSize) {
        cursor.shiftBytes(baseOffset + pos * slotSize, (totalSlotCount - pos) * slotSize, numberOfSlots * slotSize);
    }

    static void removeSlotAt(PageCursor cursor, int pos, int totalSlotCount, int baseOffset, int slotSize) {
        cursor.shiftBytes(baseOffset + (pos + 1) * slotSize, (totalSlotCount - (pos + 1)) * slotSize, -slotSize);
    }

    static void removeSlotsAt(PageCursor cursor, int fromPosInclusive, int toPosExclusive, int totalSlotCount, int baseOffset, int slotSize) {
        cursor.shiftBytes(baseOffset + toPosExclusive * slotSize, (totalSlotCount - toPosExclusive) * slotSize, (fromPosInclusive - toPosExclusive) * slotSize);
    }

    static void writeChild(PageCursor cursor, long child, long stableGeneration, long unstableGeneration, int childPos, int childOffset) {
        long write = GenerationSafePointerPair.write(cursor, child, stableGeneration, unstableGeneration);
        GenerationSafePointerPair.assertSuccess(write, cursor.getCurrentPageId(), "CHILD", stableGeneration, unstableGeneration, cursor, childOffset);
    }

    public static boolean isNode(long node) {
        return GenerationSafePointerPair.pointer(node) != 0L;
    }

    public static void goTo(PageCursor cursor, String messageOnError, long nodeId) throws IOException {
        PageCursorUtil.goTo((PageCursor)cursor, (String)messageOnError, (long)GenerationSafePointerPair.pointer(nodeId));
    }

    static void readUnreliableKeyValueSize(PageCursor cursor, int keySize, int valueSize, long keyValueSize, int pos, int valueSizeCap) {
        cursor.setCursorException(String.format("Read unreliable key, id=%d, keySize=%d, valueSize=%d, keyValueSizeCap=%d, keyHasTombstone=%b, pos=%d", cursor.getCurrentPageId(), keySize, valueSize, valueSizeCap, DynamicSizeUtil.extractTombstone(keyValueSize), pos));
    }

    static boolean isUnreliableKeyValueSize(int keySize, int valueSize, int valueSizeCap) {
        return keySize + valueSize > valueSizeCap || keySize < 0 || valueSize < 0;
    }

    static <KEY> KEY readDynamicKey(Layout<KEY, ?> layout, OffloadStore<KEY, ?> offloadStore, PageCursor cursor, KEY into, int pos, CursorContext cursorContext, int keyValueSizeCap) {
        long keyValueSize = DynamicSizeUtil.readKeyValueSize(cursor);
        boolean offload = DynamicSizeUtil.extractOffload(keyValueSize);
        if (offload) {
            long offloadId = DynamicSizeUtil.readOffloadId(cursor);
            try {
                offloadStore.readKey(offloadId, into, cursorContext);
            }
            catch (IOException e) {
                cursor.setCursorException("Failed to read key from offload, cause: " + e.getMessage());
            }
        } else {
            int valueSize;
            int keySize = DynamicSizeUtil.extractKeySize(keyValueSize);
            if (TreeNodeUtil.isUnreliableKeyValueSize(keySize, valueSize = DynamicSizeUtil.extractValueSize(keyValueSize), keyValueSizeCap)) {
                TreeNodeUtil.readUnreliableKeyValueSize(cursor, keySize, valueSize, keyValueSize, pos, keyValueSizeCap);
                return into;
            }
            layout.readKey(cursor, into, keySize);
        }
        return into;
    }
}

