/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.KeyLayout;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.io.pagecache.PageCursor;

class RootMappingLayout<ROOT_KEY>
extends Layout.Adapter<ROOT_KEY, RootMappingValue> {
    private static final long IDENTIFIER = 53468735487453L;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 1;
    private static final int KEY_LAYOUT_VERSION_SHIFT = 16;
    private final KeyLayout<ROOT_KEY> keyLayout;

    protected RootMappingLayout(KeyLayout<ROOT_KEY> keyLayout) {
        super(keyLayout.fixedSize(), keyLayout.identifier() ^ 0x30A128FC3DDDL, keyLayout.majorVersion() << 16 | 1, keyLayout.minorVersion() << 16 | 1);
        this.keyLayout = keyLayout;
    }

    @Override
    public ROOT_KEY newKey() {
        return this.keyLayout.newKey();
    }

    @Override
    public ROOT_KEY copyKey(ROOT_KEY key, ROOT_KEY into) {
        return this.keyLayout.copyKey(key, into);
    }

    @Override
    public RootMappingValue newValue() {
        return new RootMappingValue();
    }

    @Override
    public int keySize(ROOT_KEY key) {
        return this.keyLayout.keySize(key);
    }

    @Override
    public int valueSize(RootMappingValue value) {
        return 16;
    }

    @Override
    public void writeKey(PageCursor cursor, ROOT_KEY key) {
        this.keyLayout.writeKey(cursor, key);
    }

    @Override
    public void writeValue(PageCursor cursor, RootMappingValue value) {
        cursor.putLong(value.rootId);
        cursor.putLong(value.rootGeneration);
    }

    @Override
    public void readKey(PageCursor cursor, ROOT_KEY into, int keySize) {
        this.keyLayout.readKey(cursor, into, keySize);
    }

    @Override
    public void readValue(PageCursor cursor, RootMappingValue into, int valueSize) {
        into.rootId = cursor.getLong();
        into.rootGeneration = cursor.getLong();
    }

    @Override
    public void initializeAsLowest(ROOT_KEY key) {
        this.keyLayout.initializeAsLowest(key);
    }

    @Override
    public void initializeAsHighest(ROOT_KEY key) {
        this.keyLayout.initializeAsHighest(key);
    }

    @Override
    public int compare(ROOT_KEY o1, ROOT_KEY o2) {
        return this.keyLayout.compare(o1, o2);
    }

    static class RootMappingValue {
        long rootId;
        long rootGeneration;

        RootMappingValue() {
        }

        RootMappingValue initialize(Root root) {
            this.rootId = root.id();
            this.rootGeneration = root.generation();
            return this;
        }

        Root asRoot() {
            return new Root(this.rootId, this.rootGeneration);
        }
    }
}

