/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.nio.file.Path;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.io.pagecache.PageCursor;

class RightmostInChain {
    private final Path path;
    private final boolean leftmostShard;
    private long currentRightmostNode = 0L;
    private long currentRightmostRightSiblingPointer = 0L;
    private long currentRightmostRightSiblingPointerGeneration;
    private long currentRightmostNodeGeneration;
    private long leftmostNode = 0L;
    private long leftmostLeftSiblingPointer = 0L;
    private long leftmostLeftSiblingPointerGeneration;
    private long leftmostNodeGeneration;

    RightmostInChain(Path path, boolean leftmostShard) {
        this.path = path;
        this.leftmostShard = leftmostShard;
    }

    void assertNext(PageCursor cursor, long newRightmostNodeGeneration, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGeneration, long newRightmostRightSiblingPointer, long newRightmostRightSiblingPointerGeneration, GBPTreeConsistencyCheckVisitor visitor) {
        long newRightmostNode = cursor.getCurrentPageId();
        this.assertNode(newRightmostNode, newRightmostNodeGeneration, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGeneration, visitor);
        this.currentRightmostNode = newRightmostNode;
        this.currentRightmostNodeGeneration = newRightmostNodeGeneration;
        this.currentRightmostRightSiblingPointer = newRightmostRightSiblingPointer;
        this.currentRightmostRightSiblingPointerGeneration = newRightmostRightSiblingPointerGeneration;
        if (this.leftmostNode == 0L) {
            this.leftmostNode = newRightmostNode;
            this.leftmostLeftSiblingPointer = newRightmostLeftSiblingPointer;
            this.leftmostLeftSiblingPointerGeneration = newRightmostLeftSiblingPointerGeneration;
            this.leftmostNodeGeneration = newRightmostNodeGeneration;
        }
    }

    void assertNext(RightmostInChain right, GBPTreeConsistencyCheckVisitor visitor) {
        this.assertNode(right.leftmostNode, right.leftmostNodeGeneration, right.leftmostLeftSiblingPointer, right.leftmostLeftSiblingPointerGeneration, visitor);
    }

    private void assertNode(long newRightmostNode, long newRightmostNodeGeneration, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGeneration, GBPTreeConsistencyCheckVisitor visitor) {
        this.assertSiblingsAgreeOnBeingSiblings(newRightmostNode, newRightmostNodeGeneration, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGeneration, visitor);
        this.assertSiblingPointerGeneration(newRightmostNode, newRightmostNodeGeneration, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGeneration, visitor);
    }

    private void assertSiblingPointerGeneration(long newRightmostNode, long newRightmostNodeGeneration, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGeneration, GBPTreeConsistencyCheckVisitor visitor) {
        if (this.currentRightmostNodeGeneration > newRightmostLeftSiblingPointerGeneration && this.currentRightmostNode != 0L) {
            visitor.pointerHasLowerGenerationThanNode(GBPTreePointerType.leftSibling(), newRightmostNode, newRightmostLeftSiblingPointerGeneration, newRightmostLeftSiblingPointer, this.currentRightmostNodeGeneration, this.path);
        }
        if (this.currentRightmostRightSiblingPointerGeneration < newRightmostNodeGeneration && this.currentRightmostRightSiblingPointer != 0L) {
            visitor.pointerHasLowerGenerationThanNode(GBPTreePointerType.rightSibling(), this.currentRightmostNode, this.currentRightmostRightSiblingPointerGeneration, this.currentRightmostRightSiblingPointer, newRightmostNodeGeneration, this.path);
        }
    }

    private void assertSiblingsAgreeOnBeingSiblings(long newRightmostNode, long newRightmostNodeGeneration, long newRightmostLeftSiblingPointer, long newRightmostLeftSiblingPointerGeneration, GBPTreeConsistencyCheckVisitor visitor) {
        boolean siblingsPointToEachOther = true;
        if (newRightmostLeftSiblingPointer != this.currentRightmostNode && (this.currentRightmostNode != 0L || this.leftmostShard)) {
            siblingsPointToEachOther = false;
        }
        if (newRightmostNode != this.currentRightmostRightSiblingPointer && (this.currentRightmostRightSiblingPointer != 0L || this.currentRightmostNode != 0L)) {
            siblingsPointToEachOther = false;
        }
        if (!siblingsPointToEachOther) {
            visitor.siblingsDontPointToEachOther(this.currentRightmostNode, this.currentRightmostNodeGeneration, this.currentRightmostRightSiblingPointerGeneration, this.currentRightmostRightSiblingPointer, newRightmostLeftSiblingPointer, newRightmostLeftSiblingPointerGeneration, newRightmostNode, newRightmostNodeGeneration, this.path);
        }
    }

    void assertLast(GBPTreeConsistencyCheckVisitor visitor) {
        if (this.currentRightmostRightSiblingPointer != 0L) {
            visitor.rightmostNodeHasRightSibling(this.currentRightmostRightSiblingPointer, this.currentRightmostNode, this.path);
        }
    }
}

