/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Comparator;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.Comparison;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.VirtualValueGroup;

public final class ErrorValue
extends VirtualValue {
    private static final long INVALID_ARGUMENT_EXCEPTION_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(InvalidArgumentException.class);
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ErrorValue.class) + INVALID_ARGUMENT_EXCEPTION_SHALLOW_SIZE;
    private final InvalidArgumentException e;

    @Deprecated
    ErrorValue(Exception e) {
        this.e = new InvalidArgumentException(e.getMessage());
    }

    ErrorValue(ErrorGqlStatusObject gqlStatusObject, Exception e) {
        this.e = new InvalidArgumentException(gqlStatusObject, e.getMessage());
    }

    public static ErrorValue cannotProcess(String unprocessable, Exception e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N11).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.input, unprocessable).build()).build();
        return new ErrorValue(gql, e);
    }

    @Override
    public boolean equals(VirtualValue other) {
        throw this.e;
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.ERROR;
    }

    @Override
    public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        throw this.e;
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        throw this.e;
    }

    @Override
    protected int computeHashToMemoize() {
        throw this.e;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) {
        throw this.e;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        throw this.e;
    }

    @Override
    public String getTypeName() {
        return "Error";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOf((String)this.e.getMessage());
    }
}

