/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.configuration.SettingBuilder;
import org.neo4j.configuration.SettingConstraint;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;

public final class SettingImpl<T>
implements Setting<T> {
    private final String name;
    private final SettingImpl<T> dependency;
    private final SettingValueParser<T> parser;
    private final T defaultValue;
    private final List<SettingConstraint<T>> constraints;
    private final boolean dynamic;
    private final boolean immutable;
    private boolean internal;
    private String description;
    private boolean deprecated;
    private String sourceLocation;

    private SettingImpl(String name, SettingValueParser<T> parser, T defaultValue, List<SettingConstraint<T>> constraints, boolean dynamic, boolean immutable, boolean internal, SettingImpl<T> dependency) {
        this.name = name;
        this.parser = parser;
        this.dependency = dependency;
        this.constraints = constraints;
        this.defaultValue = defaultValue;
        this.dynamic = dynamic;
        this.internal = internal;
        this.immutable = immutable;
    }

    public static <T> SettingBuilder<T> newBuilder(String name, SettingValueParser<T> parser, T defaultValue) {
        return SettingBuilder.newBuilder(name, parser, defaultValue);
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public T parse(String value) {
        if (value == null) {
            return null;
        }
        return this.parser.parse(value);
    }

    public String valueToString(T value) {
        if (value != null) {
            return this.parser.valueToString(value);
        }
        return null;
    }

    T solveDefault(T value, T defaultValue) {
        return this.parser.solveDefault(value, defaultValue);
    }

    T solveDependency(T value, T dependencyValue) {
        return this.parser.solveDependency(value, dependencyValue);
    }

    public void validate(T value, Configuration config) {
        if (value != null) {
            if (!this.parser.getType().isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException(String.format("Setting '%s' can not have value '%s'. Should be of type '%s', but is '%s'", this.name, value, this.parser.getType().getSimpleName(), value.getClass().getSimpleName()));
            }
            try {
                this.parser.validate(value);
                for (SettingConstraint<T> constraint : this.constraints) {
                    constraint.validate(value, config);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Failed to validate '%s' for '%s': %s", value, this.name(), e.getMessage()), e);
            }
        }
    }

    public String toString() {
        return String.format("%s, %s", this.name, this.validValues(false));
    }

    public String validValues() {
        return this.validValues(true);
    }

    private String validValues(boolean capitalize) {
        Object desc = this.parser.getDescription();
        if (!this.constraints.isEmpty()) {
            String constraintDesc = this.constraints.stream().map(SettingConstraint::getDescription).collect(Collectors.joining(" and "));
            desc = (String)desc + this.parser.constraintConjunction() + constraintDesc;
        }
        if (this.dependency != null) {
            desc = String.format("%s. %s from %s", desc, this.parser.getSolverDescription(), this.dependency.name());
        }
        desc = (String)desc + ".";
        if (capitalize) {
            return StringUtils.capitalize((String)desc);
        }
        return desc;
    }

    public SettingImpl<T> dependency() {
        return this.dependency;
    }

    public List<SettingConstraint<T>> constraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public String description() {
        return this.description != null ? this.description : this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingImpl setting = (SettingImpl)o;
        return this.name.equals(setting.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String name() {
        return this.name;
    }

    public boolean dynamic() {
        return this.dynamic;
    }

    public boolean immutable() {
        return this.immutable;
    }

    public boolean internal() {
        return this.internal;
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setInternal() {
        this.internal = true;
    }

    void setDeprecated() {
        this.deprecated = true;
    }

    void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public SettingValueParser<T> parser() {
        return this.parser;
    }

    public static class Builder<T>
    implements SettingBuilder<T> {
        private final String name;
        private final SettingValueParser<T> parser;
        private final List<SettingConstraint<T>> constraints = new ArrayList<SettingConstraint<T>>();
        private final T defaultValue;
        private boolean dynamic;
        private boolean immutable;
        private boolean internal;
        private SettingImpl<T> dependency;

        Builder(String name, SettingValueParser<T> parser, T defaultValue) {
            this.name = name;
            this.parser = parser;
            this.defaultValue = defaultValue;
        }

        @Override
        public Builder<T> dynamic() {
            this.dynamic = true;
            return this;
        }

        @Override
        public Builder<T> immutable() {
            this.immutable = true;
            return this;
        }

        @Override
        public Builder<T> internal() {
            this.internal = true;
            return this;
        }

        @Override
        public Builder<T> addConstraint(SettingConstraint<T> constraint) {
            constraint.setParser(this.parser);
            this.constraints.add(constraint);
            return this;
        }

        @Override
        public Builder<T> setDependency(Setting<T> setting) {
            this.dependency = (SettingImpl)setting;
            return this;
        }

        @Override
        public Setting<T> build() {
            if (this.immutable && this.dynamic) {
                throw new IllegalArgumentException("Setting can not be both dynamic and immutable");
            }
            if (this.dependency != null && !this.dependency.immutable()) {
                throw new IllegalArgumentException("Setting can only have immutable dependency");
            }
            return new SettingImpl<T>(this.name, this.parser, this.defaultValue, this.constraints, this.dynamic, this.immutable, this.internal, this.dependency);
        }
    }
}

