/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectIntMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectIntMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectIntEmptyMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableObjectIntSingletonMap<K>
extends AbstractImmutableObjectIntMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    private final K key1;
    private final int value1;

    ImmutableObjectIntSingletonMap(K key1, int value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)ObjectIntHashMap.newWithKeysValues(this.key1, this.value1).intIterator());
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(IntPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableIntCollection select(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntLists.immutable.with(this.value1) : IntLists.immutable.with();
    }

    public ImmutableIntCollection reject(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntLists.immutable.with() : IntLists.immutable.with(this.value1);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)IntLists.immutable.with(this.value1));
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long sum() {
        return this.value1;
    }

    public int min() {
        return this.value1;
    }

    public int max() {
        return this.value1;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.value1;
    }

    public int minIfEmpty(int defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public int[] toSortedArray() {
        return new int[]{this.value1};
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.value1);
    }

    public int[] toArray() {
        return new int[]{this.value1};
    }

    public int[] toArray(int[] target) {
        if (target.length < 1) {
            target = new int[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(int value) {
        return this.value1 == value;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newListWith(this.value1);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.value1);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.value1);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableObjectIntMap<K> newWithKeyValue(K key, int value) {
        return ObjectIntMaps.immutable.withAll(ObjectIntHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectIntMap<K> newWithoutKey(K key) {
        return ImmutableObjectIntSingletonMap.nullSafeEquals(this.key1, key) ? ImmutableObjectIntEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public ImmutableObjectIntMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectIntHashMap<K> map = new ObjectIntHashMap<K>(this);
        for (K key : keys) {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public int get(Object key) {
        return this.getIfAbsent(key, 0);
    }

    public int getOrThrow(Object key) {
        if (ImmutableObjectIntSingletonMap.nullSafeEquals(this.key1, key)) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public int getIfAbsent(Object key, int ifAbsent) {
        return ImmutableObjectIntSingletonMap.nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key) {
        return ImmutableObjectIntSingletonMap.nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(int value) {
        return this.value1 == value;
    }

    public void forEachValue(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectIntProcedure<? super K> objectIntProcedure) {
        objectIntProcedure.value(this.key1, this.value1);
    }

    public ImmutableObjectIntMap<K> select(ObjectIntPredicate<? super K> objectIntPredicate) {
        return objectIntPredicate.accept(this.key1, this.value1) ? ObjectIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableObjectIntEmptyMap.INSTANCE;
    }

    public ImmutableObjectIntMap<K> reject(ObjectIntPredicate<? super K> objectIntPredicate) {
        return objectIntPredicate.accept(this.key1, this.value1) ? ImmutableObjectIntEmptyMap.INSTANCE : ObjectIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectIntMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public Set<K> keySet() {
        return Sets.immutable.of(this.key1).castToSet();
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of((MutableIntCollection)IntArrayList.newListWith(this.value1));
    }

    public LazyIterable<K> keysView() {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ObjectIntPair<K>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableIntObjectMap<K> flipUniqueValues() {
        return IntObjectMaps.immutable.with(this.value1, this.key1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectIntMap)) {
            return false;
        }
        ObjectIntMap map = (ObjectIntMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectIntMap.ImmutableObjectIntMapSerializationProxy(this);
    }
}

