/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongBytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableByteLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongByteMap;
import org.eclipse.collections.api.map.primitive.LongByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongBytePair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongByteProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteBags;
import org.eclipse.collections.impl.factory.primitive.ByteLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.map.mutable.primitive.LongByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

final class ImmutableLongByteHashMap
implements ImmutableLongByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongByteMap delegate;

    ImmutableLongByteHashMap(LongByteMap delegate) {
        this.delegate = new LongByteHashMap(delegate);
    }

    public byte get(long key) {
        return this.delegate.get(key);
    }

    public byte getIfAbsent(long key, byte ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(long key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(byte value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongByteProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<LongBytePair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableByteLongMap flipUniqueValues() {
        MutableByteLongMap result = ByteLongMaps.mutable.empty();
        this.forEachKeyValue((LongByteProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableLongByteMap select(LongBytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongByteMap reject(LongBytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableByteIterator iterator = this.delegate.byteIterator();
            while (iterator.hasNext()) {
                MutableByteBag batch = ByteBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableLongByteMap toImmutable() {
        return this;
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)this.delegate.byteIterator());
    }

    public void each(ByteProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableByteBag select(BytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteBag reject(BytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public byte max() {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte min() {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return this.delegate.toSortedList();
    }

    public byte[] toArray() {
        return this.delegate.toArray();
    }

    public byte[] toArray(byte[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(byte value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList() {
        return this.delegate.toList();
    }

    public MutableByteSet toSet() {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag() {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableLongByteMap newWithKeyValue(long key, byte value) {
        LongByteHashMap map = new LongByteHashMap(this.size() + 1);
        map.putAll((LongByteMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongByteMap newWithoutKey(long key) {
        LongByteHashMap map = new LongByteHashMap(this.size());
        map.putAll((LongByteMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongByteMap newWithoutAllKeys(LongIterable keys) {
        LongByteHashMap map = new LongByteHashMap(this.size());
        map.putAll((LongByteMap)this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableLongByteMapSerializationProxy((LongByteMap)this);
    }

    protected static class ImmutableLongByteMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongByteMap map;

        public ImmutableLongByteMapSerializationProxy() {
        }

        protected ImmutableLongByteMapSerializationProxy(LongByteMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((LongByteProcedure)new CheckedLongByteProcedure(){

                    @Override
                    public void safeValue(long key, byte value) throws IOException {
                        out.writeLong(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongByteHashMap deserializedMap = new LongByteHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readLong(), in.readByte());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

