/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleCharMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleCharMap;
import org.eclipse.collections.impl.factory.primitive.DoubleCharMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleCharSingletonMap;

public class ImmutableDoubleCharMapFactoryImpl
implements ImmutableDoubleCharMapFactory {
    public static final ImmutableDoubleCharMapFactory INSTANCE = new ImmutableDoubleCharMapFactoryImpl();

    public ImmutableDoubleCharMap empty() {
        return ImmutableDoubleCharEmptyMap.INSTANCE;
    }

    public ImmutableDoubleCharMap of() {
        return this.empty();
    }

    public ImmutableDoubleCharMap with() {
        return this.empty();
    }

    public ImmutableDoubleCharMap of(double key, char value) {
        return this.with(key, value);
    }

    public ImmutableDoubleCharMap with(double key, char value) {
        return new ImmutableDoubleCharSingletonMap(key, value);
    }

    public ImmutableDoubleCharMap ofAll(DoubleCharMap map) {
        return this.withAll(map);
    }

    public ImmutableDoubleCharMap withAll(DoubleCharMap map) {
        if (map instanceof ImmutableDoubleCharMap) {
            return (ImmutableDoubleCharMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleCharSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleCharHashMap(map);
    }

    public <T> ImmutableDoubleCharMap from(Iterable<T> iterable, DoubleFunction<? super T> keyFunction, CharFunction<? super T> valueFunction) {
        return DoubleCharMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

