/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.IntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.Counter;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.SynchronizedIntBag;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableIntBag;
import org.eclipse.collections.impl.block.factory.primitive.IntToIntFunctions;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.eclipse.collections.impl.primitive.AbstractIntIterable;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class IntHashBag
extends AbstractIntIterable
implements MutableIntBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private IntIntHashMap items;
    private int size;

    public IntHashBag() {
        this.items = new IntIntHashMap();
    }

    public IntHashBag(int size) {
        this.items = new IntIntHashMap(size);
    }

    public IntHashBag(IntIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public IntHashBag(int ... elements) {
        this();
        this.addAll(elements);
    }

    public IntHashBag(IntHashBag bag) {
        this.items = new IntIntHashMap(bag.sizeDistinct());
        this.addAll(bag);
    }

    public static IntHashBag newBag(int size) {
        return new IntHashBag(size);
    }

    public static IntHashBag newBagWith(int ... source) {
        return new IntHashBag(source);
    }

    public static IntHashBag newBag(IntIterable source) {
        if (source instanceof IntHashBag) {
            return new IntHashBag((IntHashBag)source);
        }
        return new IntHashBag(source);
    }

    public static IntHashBag newBag(IntBag source) {
        return new IntHashBag((IntIterable)source);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    public int size() {
        return this.size;
    }

    public int sizeDistinct() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    public IntHashBag with(int element) {
        this.add(element);
        return this;
    }

    public IntHashBag with(int element1, int element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public IntHashBag with(int element1, int element2, int element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    public IntHashBag withAll(IntIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    public IntHashBag without(int element) {
        this.remove(element);
        return this;
    }

    public IntHashBag withoutAll(IntIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    public boolean contains(int value) {
        return this.items.containsKey(value);
    }

    public int occurrencesOf(int item) {
        return this.items.get(item);
    }

    public void forEachWithOccurrences(IntIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    public IntHashBag selectByOccurrences(IntPredicate predicate) {
        IntHashBag result = new IntHashBag();
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(occurrences)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public MutableIntSet selectUnique() {
        MutableIntSet result = IntSets.mutable.empty();
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            if (occurrences == 1) {
                result.add(each);
            }
        });
        return result;
    }

    public MutableList<IntIntPair> topOccurrences(int count) {
        return this.occurrencesSortingBy(count, (IntFunction<IntIntPair>)(IntFunction & Serializable)item -> -item.getTwo(), (MutableList<IntIntPair>)Lists.mutable.empty());
    }

    public MutableList<IntIntPair> bottomOccurrences(int count) {
        return this.occurrencesSortingBy(count, (IntFunction<IntIntPair>)((IntFunction & Serializable)IntIntPair::getTwo), (MutableList<IntIntPair>)Lists.mutable.empty());
    }

    protected MutableList<IntIntPair> occurrencesSortingBy(int n, IntFunction<IntIntPair> function, MutableList<IntIntPair> returnWhenEmpty) {
        int keySize;
        if (n < 0) {
            throw new IllegalArgumentException("Cannot use a value of n < 0");
        }
        if (n == 0) {
            return returnWhenEmpty;
        }
        MutableList sorted = this.toListWithOccurrences().sortThisByInt(function);
        MutableList results = sorted.subList(0, keySize).toList();
        for (keySize = Math.min(n, this.sizeDistinct()); keySize < sorted.size() && ((IntIntPair)results.getLast()).getTwo() == ((IntIntPair)sorted.get(keySize)).getTwo(); ++keySize) {
            results.add(sorted.get(keySize));
        }
        return results;
    }

    protected MutableList<IntIntPair> toListWithOccurrences() {
        MutableList result = Lists.mutable.withInitialCapacity(this.sizeDistinct());
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, count) -> result.add((Object)PrimitiveTuples.pair(each, count)));
        return result;
    }

    public boolean add(int item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    public boolean remove(int item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    public boolean removeIf(IntPredicate predicate) {
        boolean changed = false;
        MutableIntIterator iterator = this.items.keySet().intIterator();
        while (iterator.hasNext()) {
            int key = iterator.next();
            if (!predicate.accept(key)) continue;
            this.size -= this.items.get(key);
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public boolean addAll(int ... source) {
        if (source.length == 0) {
            return false;
        }
        for (int each : source) {
            this.add(each);
        }
        return true;
    }

    public boolean addAll(IntIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof IntBag) {
            IntBag otherBag = (IntBag)source;
            otherBag.forEachWithOccurrences(this::addOccurrences);
        } else {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                int each = iterator.next();
                this.add(each);
            }
        }
        return true;
    }

    public boolean removeAll(int ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (int each : source) {
            int occurrences = this.items.removeKeyIfAbsent(each, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(IntIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof IntBag) {
            IntBag otherBag = (IntBag)source;
            otherBag.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
                int oldOccurrences = this.items.removeKeyIfAbsent(each, 0);
                this.size -= oldOccurrences;
            });
        } else {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                int each2 = iterator.next();
                int occurrences2 = this.items.removeKeyIfAbsent(each2, 0);
                this.size -= occurrences2;
            }
        }
        return this.size() != oldSize;
    }

    public boolean retainAll(IntIterable source) {
        int oldSize = this.size();
        IntSet sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
        IntHashBag retained = this.select(arg_0 -> ((IntSet)sourceSet).contains(arg_0));
        if (retained.size() != oldSize) {
            this.items = retained.items;
            this.size = retained.size;
            return true;
        }
        return false;
    }

    public boolean retainAll(int ... source) {
        return this.retainAll(IntHashSet.newSetWith(source));
    }

    public void addOccurrences(int item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, (IntToIntFunction & Serializable)intParameter -> intParameter + occurrences);
            this.size += occurrences;
        }
    }

    public boolean removeOccurrences(int item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, (IntToIntFunction & Serializable)intParameter -> intParameter - occurrences);
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    public void each(IntProcedure procedure) {
        this.items.forEachKeyValue((IntIntProcedure & Serializable)(key, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                procedure.value(key);
            }
        });
    }

    public IntHashBag select(IntPredicate predicate) {
        IntHashBag result = new IntHashBag();
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(each)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public IntHashBag reject(IntPredicate predicate) {
        IntHashBag result = new IntHashBag();
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            if (!predicate.accept(each)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object[] result = new Object[]{injectedValue};
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                result[0] = function.valueOf(result[0], each);
            }
        });
        return (T)result[0];
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)IntBags.mutable.withAll((IntIterable)this));
            } else {
                MutableIntIterator iterator = this.intIterator();
                while (iterator.hasNext()) {
                    MutableIntBag batch = IntBags.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch);
                }
            }
        }
        return result;
    }

    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof IntBag)) {
            return false;
        }
        IntBag bag = (IntBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy((IntPredicate & Serializable)key -> this.occurrencesOf(key) == bag.occurrencesOf(key));
    }

    public int hashCode() {
        Counter result = new Counter();
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(eachItem, occurrences) -> result.add(eachItem ^ occurrences));
        return result.getCount();
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue((IntIntProcedure & Serializable)(each, occurrences) -> {
                try {
                    for (int i = 0; i < occurrences; ++i) {
                        if (!firstItem[0]) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(each));
                        firstItem[0] = false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int count(IntPredicate predicate) {
        Counter result = new Counter();
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            if (predicate.accept(each)) {
                result.add(occurrences);
            }
        });
        return result.getCount();
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    public <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> result.addOccurrences(function.valueOf(each), occurrences));
        return result;
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    public long sum() {
        long[] result = new long[]{0L};
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            result[0] = result[0] + (long)each * (long)occurrences;
        });
        return result[0];
    }

    public int[] toArray() {
        int[] array = new int[this.size()];
        int[] index = new int[]{0};
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                array[index[0]] = each;
                index[0] = index[0] + 1;
            }
        });
        return array;
    }

    public int[] toArray(int[] array) {
        if (array.length < this.size()) {
            array = new int[this.size()];
        }
        int[] index = new int[]{0};
        int[] finalBypass = array;
        this.forEachWithOccurrences((IntIntProcedure & Serializable)(each, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                finalBypass[index[0]] = each;
                index[0] = index[0] + 1;
            }
        });
        return array;
    }

    public MutableIntBag asUnmodifiable() {
        return new UnmodifiableIntBag(this);
    }

    public MutableIntBag asSynchronized() {
        return new SynchronizedIntBag(this);
    }

    public ImmutableIntBag toImmutable() {
        return IntBags.immutable.withAll((IntIterable)this);
    }

    public IntHashBag newEmpty() {
        return new IntHashBag();
    }

    public MutableIntIterator intIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue((IntIntProcedure & Serializable)(each, occurrences) -> {
                try {
                    out.writeInt(each);
                    out.writeInt(occurrences);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        this.items = new IntIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.addOccurrences(in.readInt(), in.readInt());
        }
    }

    private class InternalIterator
    implements MutableIntIterator {
        private MutableIntIterator intIterator;
        private int currentItem;
        private int occurrences;
        private boolean canRemove;

        private InternalIterator() {
            this.intIterator = IntHashBag.this.items.keySet().intIterator();
        }

        public boolean hasNext() {
            return this.occurrences > 0 || this.intIterator.hasNext();
        }

        public int next() {
            if (this.occurrences == 0) {
                this.currentItem = this.intIterator.next();
                this.occurrences = IntHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            this.canRemove = true;
            return this.currentItem;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (this.occurrences == 0) {
                this.intIterator.remove();
                IntHashBag.this.size--;
            } else {
                IntHashBag.this.remove(this.currentItem);
            }
            this.canRemove = false;
        }
    }
}

