/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableCharBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableCharEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableCharHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableCharSingletonBag;
import org.eclipse.collections.impl.factory.primitive.CharBags;

public class ImmutableCharBagFactoryImpl
implements ImmutableCharBagFactory {
    public static final ImmutableCharBagFactory INSTANCE = new ImmutableCharBagFactoryImpl();

    public ImmutableCharBag empty() {
        return ImmutableCharEmptyBag.INSTANCE;
    }

    public ImmutableCharBag of() {
        return this.empty();
    }

    public ImmutableCharBag with() {
        return this.empty();
    }

    public ImmutableCharBag of(char one) {
        return this.with(one);
    }

    public ImmutableCharBag with(char one) {
        return new ImmutableCharSingletonBag(one);
    }

    public ImmutableCharBag of(char ... items) {
        return this.with(items);
    }

    public ImmutableCharBag with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharHashBag.newBagWith(items);
    }

    public ImmutableCharBag ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public ImmutableCharBag withAll(CharIterable items) {
        if (items instanceof ImmutableCharBag) {
            return (ImmutableCharBag)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableCharBag ofAll(Iterable<Character> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableCharBag withAll(Iterable<Character> iterable) {
        return CharBags.mutable.withAll(iterable).toImmutable();
    }
}

