/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.hadoop.fs.Path;

public class FSDataInputStream
extends InputStream {
    private final RandomAccessFile input;

    public FSDataInputStream(Path p) throws FileNotFoundException {
        this.input = new RandomAccessFile(p.file(), "r");
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        try {
            this.input.readFully(buf, off, len);
            return len;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void seek(long pos) {
        try {
            this.input.seek(pos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readFully(byte[] buf, int a, int b) {
        try {
            this.input.readFully(buf, a, b);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

