/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.Measurable;
import org.neo4j.memory.MemoryTracker;

public class LongProbeTable<V extends Measurable>
extends DefaultCloseListenable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LongProbeTable.class);
    private final MemoryTracker scopedMemoryTracker;
    private MutableLongObjectMap<HeapTrackingArrayList<V>> map;

    public static <V extends Measurable> LongProbeTable<V> createLongProbeTable(MemoryTracker memoryTracker) {
        MemoryTracker scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        return new LongProbeTable<V>(scopedMemoryTracker);
    }

    private LongProbeTable(MemoryTracker scopedMemoryTracker) {
        this.scopedMemoryTracker = scopedMemoryTracker;
        this.map = HeapTrackingCollections.newLongObjectMap((MemoryTracker)scopedMemoryTracker);
    }

    public void put(long key, V value) {
        ((HeapTrackingArrayList)this.map.getIfAbsentPutWith(key, HeapTrackingCollections::newArrayList, (Object)this.scopedMemoryTracker)).add(value);
        this.scopedMemoryTracker.allocateHeap(value.estimatedHeapUsage());
    }

    public Iterator<V> get(long key) {
        HeapTrackingArrayList entry = (HeapTrackingArrayList)this.map.get(key);
        if (entry == null) {
            return Collections.emptyIterator();
        }
        return entry.iterator();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void closeInternal() {
        if (this.map != null) {
            this.map = null;
            this.scopedMemoryTracker.close();
        }
    }

    public boolean isClosed() {
        return this.map == null;
    }
}

