/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.transaction.log.FormatSwitchingReadAheadLogChannelException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.enveloped.EnvelopeReadChannel;
import org.neo4j.memory.MemoryTracker;

public class FormatSwitchingReadAheadLogChannel
implements ReadableLogChannel {
    ReadableLogChannel delegate;

    FormatSwitchingReadAheadLogChannel(LogVersionedStoreChannel startingChannel, final LogVersionBridge bridge, final MemoryTracker memoryTracker, final boolean raw) {
        this.delegate = new ReadAheadLogChannel(startingChannel, memoryTracker){

            @Override
            protected LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
                LogVersionedStoreChannel next = bridge.next(channel, raw);
                if (!next.getLogFormatVersion().usesSegments()) {
                    return next;
                }
                FormatSwitchingReadAheadLogChannel.this.delegate = new EnvelopeReadChannel(next, next.getLogFormatVersion().getDefaultSegmentBlockSize(), bridge, memoryTracker, raw);
                throw FormatSwitchingReadAheadLogChannelException.INSTANCE;
            }
        };
    }

    public long getLogVersion() {
        return this.delegate.getLogVersion();
    }

    public LogFormat getLogFormatVersion() {
        return this.delegate.getLogFormatVersion();
    }

    public byte markAndGetVersion(LogPositionMarker marker) throws IOException {
        try {
            return this.delegate.markAndGetVersion(marker);
        }
        catch (FormatSwitchingReadAheadLogChannelException e) {
            return this.delegate.markAndGetVersion(marker);
        }
    }

    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) throws IOException {
        return this.delegate.getCurrentLogPosition(positionMarker);
    }

    public LogPosition getCurrentLogPosition() throws IOException {
        return this.delegate.getCurrentLogPosition();
    }

    public void setLogPosition(LogPositionMarker positionMarker) throws IOException {
        this.delegate.setLogPosition(positionMarker);
    }

    public void setCurrentPosition(long byteOffset) throws IOException {
        this.delegate.setCurrentPosition(byteOffset);
    }

    public long position() throws IOException {
        return this.delegate.position();
    }

    public void beginChecksum() {
        this.delegate.beginChecksum();
    }

    public int getChecksum() {
        return this.delegate.getChecksum();
    }

    public int endChecksumAndValidate() throws IOException {
        return this.delegate.endChecksumAndValidate();
    }

    public byte get() throws IOException {
        return this.delegate.get();
    }

    public short getShort() throws IOException {
        return this.delegate.getShort();
    }

    public int getInt() throws IOException {
        return this.delegate.getInt();
    }

    public long getLong() throws IOException {
        return this.delegate.getLong();
    }

    public float getFloat() throws IOException {
        return this.delegate.getFloat();
    }

    public double getDouble() throws IOException {
        return this.delegate.getDouble();
    }

    public void get(byte[] bytes, int length) throws IOException {
        this.delegate.get(bytes, length);
    }

    public byte getVersion() throws IOException {
        return this.delegate.getVersion();
    }

    public void position(long byteOffset) throws IOException {
        this.delegate.position(byteOffset);
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

