/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.PartitionedTokenScan;
import org.neo4j.kernel.impl.newapi.InternalTokenIndexCursor;
import org.neo4j.kernel.impl.newapi.PartitionedTokenCursorScan;

public class PartitionedTokenIndexCursorScan<Cursor extends Cursor>
implements PartitionedScan<Cursor>,
PartitionedTokenCursorScan<Cursor> {
    private final TokenPredicate query;
    private final PartitionedTokenScan tokenScan;

    PartitionedTokenIndexCursorScan(TokenPredicate query, PartitionedTokenScan tokenScan) {
        this.query = query;
        this.tokenScan = tokenScan;
    }

    @Override
    public int getNumberOfPartitions() {
        return this.tokenScan.getNumberOfPartitions();
    }

    @Override
    public boolean reservePartition(Cursor cursor, ExecutionContext executionContext) {
        InternalTokenIndexCursor indexCursor = (InternalTokenIndexCursor)cursor;
        indexCursor.initState(executionContext.dataRead(), executionContext.txStateHolder(), executionContext.accessModeProvider());
        IndexProgressor indexProgressor = this.tokenScan.reservePartition((IndexProgressor.EntityTokenClient)indexCursor, executionContext.cursorContext());
        if (indexProgressor == IndexProgressor.EMPTY) {
            return false;
        }
        indexCursor.initializeQuery(indexProgressor, this.query.tokenId(), null, null);
        return true;
    }

    @Override
    public PartitionedTokenScan getTokenScan() {
        return this.tokenScan;
    }
}

