/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingLongConsumer;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.Upgrade;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityAlreadyExistsException;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.NodeLabelExistenceSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.RelationshipEndpointLabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SettingsAccessor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeLabelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeRepresentation;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConflictingConstraintException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintWithNameAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.EquivalentSchemaRuleAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.IncompatibleGraphTypeDependenceException;
import org.neo4j.kernel.api.exceptions.schema.IndexBelongsToConstraintException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexWithNameAlreadyExistsException;
import org.neo4j.kernel.api.exceptions.schema.NoSuchConstraintException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedSchemaComponentException;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfigUtils;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipValueIndexCursor;
import org.neo4j.kernel.impl.newapi.FilteringNodeCursorWrapper;
import org.neo4j.kernel.impl.newapi.FilteringRelationshipScanCursorWrapper;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.IndexReaders;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelRead;
import org.neo4j.kernel.impl.newapi.KernelSchemaRead;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.SchemaMatcher;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.NodeIdAllocator;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.RelationshipIdAllocator;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionStateBehaviour;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Operations
implements Write,
SchemaWrite,
Upgrade {
    private final KernelTransactionImplementation ktx;
    private final KernelRead kernelRead;
    private final KernelSchemaRead schemaRead;
    private final AccessModeProvider accessModeProvider;
    private final StorageReader storageReader;
    private final CommandCreationContext commandCreationContext;
    private final DbmsRuntimeVersionProvider dbmsRuntimeVersionProvider;
    private final KernelVersionProvider kernelVersionProvider;
    private final StorageLocks storageLocks;
    private final KernelToken token;
    private final IndexTxStateUpdater updater;
    private final DefaultPooledCursors cursors;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final ConstraintSemantics constraintSemantics;
    private final IndexingProvidersService indexProviders;
    private final MemoryTracker memoryTracker;
    private final boolean additionLockVerification;
    private final boolean dependentConstraintsEnabled;
    private final boolean relationshipEndpointLabelAndNodeLabelExistenceConstraintsEnabled;
    private final boolean alwaysUseLatestIndexProvider;
    private final TransactionStateBehaviour transactionStateBehaviour;
    private DefaultNodeCursor nodeCursor;
    private DefaultNodeCursor restrictedNodeCursor;
    private DefaultPropertyCursor propertyCursor;
    private DefaultPropertyCursor restrictedPropertyCursor;
    private DefaultRelationshipScanCursor relationshipCursor;
    private DefaultRelationshipScanCursor restrictedRelationshipCursor;

    public Operations(KernelRead kernelRead, StorageReader storageReader, IndexTxStateUpdater updater, CommandCreationContext commandCreationContext, DbmsRuntimeVersionProvider dbmsRuntimeVersionProvider, KernelVersionProvider kernelVersionProvider, StorageLocks storageLocks, KernelTransactionImplementation ktx, KernelSchemaRead schemaRead, KernelToken token, DefaultPooledCursors cursors, ConstraintIndexCreator constraintIndexCreator, ConstraintSemantics constraintSemantics, IndexingProvidersService indexProviders, Config config, MemoryTracker memoryTracker, AccessModeProvider accessModeProvider, TransactionStateBehaviour transactionStateBehaviour) {
        this.storageReader = storageReader;
        this.commandCreationContext = commandCreationContext;
        this.dbmsRuntimeVersionProvider = dbmsRuntimeVersionProvider;
        this.kernelVersionProvider = kernelVersionProvider;
        this.storageLocks = storageLocks;
        this.schemaRead = schemaRead;
        this.accessModeProvider = accessModeProvider;
        this.token = token;
        this.kernelRead = kernelRead;
        this.ktx = ktx;
        this.updater = updater;
        this.cursors = cursors;
        this.constraintIndexCreator = constraintIndexCreator;
        this.constraintSemantics = constraintSemantics;
        this.indexProviders = indexProviders;
        this.memoryTracker = memoryTracker;
        this.additionLockVerification = (Boolean)config.get(GraphDatabaseInternalSettings.additional_lock_verification);
        this.dependentConstraintsEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.dependent_constraints_enabled);
        this.relationshipEndpointLabelAndNodeLabelExistenceConstraintsEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.relationship_endpoint_label_and_node_label_existence_constraints);
        this.alwaysUseLatestIndexProvider = (Boolean)config.get(GraphDatabaseInternalSettings.always_use_latest_index_provider);
        this.transactionStateBehaviour = transactionStateBehaviour;
    }

    public void initialize(CursorContext cursorContext) {
        this.nodeCursor = this.cursors.allocateFullAccessNodeCursor(cursorContext, this.memoryTracker);
        this.propertyCursor = this.cursors.allocateFullAccessPropertyCursor(cursorContext, this.memoryTracker);
        this.relationshipCursor = this.cursors.allocateFullAccessRelationshipScanCursor(cursorContext, this.memoryTracker);
        this.restrictedNodeCursor = this.cursors.allocateNodeCursor(cursorContext, this.memoryTracker);
        this.restrictedPropertyCursor = this.cursors.allocatePropertyCursor(cursorContext, this.memoryTracker);
        this.restrictedRelationshipCursor = (DefaultRelationshipScanCursor)this.cursors.allocateRelationshipScanCursor(cursorContext, this.memoryTracker);
    }

    private <E extends Exception> long internalNodeCreate(NodeIdAllocator idAllocator, ThrowingLongConsumer<E> checkAfterLocked) throws E {
        this.ktx.securityAuthorizationHandler().assertAllowsCreateNode(this.ktx.securityContext(), this.token::labelGetName, null);
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        long nodeId = idAllocator.reserveNode();
        this.storageLocks.acquireExclusiveNodeLock(this.ktx.lockTracer(), new long[]{nodeId});
        if (checkAfterLocked != null) {
            checkAfterLocked.accept(nodeId);
        }
        txState.nodeDoCreate(nodeId);
        return nodeId;
    }

    public long nodeCreate() {
        return this.internalNodeCreate((NodeIdAllocator)this.commandCreationContext, null);
    }

    public void nodeWithSpecificIdCreate(long nodeId) throws EntityAlreadyExistsException {
        this.internalNodeCreate(() -> nodeId, this::assertNodeDoesntExist);
        this.ktx.needsHighIdTracking();
    }

    private <E extends Exception> long internalNodeCreateWithLabels(NodeIdAllocator idAllocator, int[] labels, ThrowingLongConsumer<E> checkAfterLocked) throws E, ConstraintValidationException {
        if (labels == null || labels.length == 0) {
            return this.internalNodeCreate(idAllocator, checkAfterLocked);
        }
        this.ktx.securityAuthorizationHandler().assertAllowsCreateNode(this.ktx.securityContext(), this.token::labelGetName, labels);
        this.ktx.assertOpen();
        long[] lockingIds = this.acquireSharedLabelLocks(labels);
        this.sharedTokenSchemaLock(ResourceType.LABEL);
        TransactionState txState = this.ktx.txState();
        long nodeId = idAllocator.reserveNode();
        this.storageLocks.acquireExclusiveNodeLock(this.ktx.lockTracer(), new long[]{nodeId});
        if (checkAfterLocked != null) {
            checkAfterLocked.accept(nodeId);
        }
        txState.nodeDoCreate(nodeId);
        this.nodeCursor.single(nodeId, this.kernelRead, this.ktx, this.accessModeProvider);
        this.nodeCursor.next();
        int prevLabel = -1;
        for (long lockingId : lockingIds) {
            int label = (int)lockingId;
            if (label == prevLabel) continue;
            this.checkConstraintsAndAddLabelToNode(nodeId, label);
            prevLabel = label;
        }
        return nodeId;
    }

    public long nodeCreateWithLabels(int[] labels) throws ConstraintValidationException {
        return this.internalNodeCreateWithLabels((NodeIdAllocator)this.commandCreationContext, labels, null);
    }

    public void nodeWithSpecificIdCreateWithLabels(long nodeId, int[] labels) throws EntityAlreadyExistsException, ConstraintValidationException {
        this.internalNodeCreateWithLabels(() -> nodeId, labels, this::assertNodeDoesntExist);
        this.ktx.needsHighIdTracking();
    }

    private long[] acquireSharedLabelLocks(int[] labels) {
        int labelCount = labels.length;
        long[] lockingIds = new long[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            lockingIds[i] = labels[i];
        }
        Arrays.sort(lockingIds);
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), ResourceType.LABEL, lockingIds);
        return lockingIds;
    }

    public boolean nodeDelete(long node) {
        this.ktx.assertOpen();
        return this.nodeDelete(node, true);
    }

    public int nodeDetachDelete(long nodeId, Write.DetachDeleteConsumer deletedRelationshipConsumer) {
        this.ktx.assertOpen();
        this.storageLocks.acquireNodeDeletionLock((ReadableTransactionState)this.ktx.txState(), this.ktx.lockTracer(), nodeId);
        NodeCursor nodeCursor = this.ktx.ambientNodeCursor();
        this.ktx.dataRead().singleNode(nodeId, nodeCursor);
        int deletedRelationships = 0;
        if (nodeCursor.next()) {
            try (RelationshipTraversalCursor rels = RelationshipSelections.allCursor((CursorFactory)this.ktx.cursors(), (NodeCursor)nodeCursor, null, (CursorContext)this.ktx.cursorContext());){
                while (rels.next()) {
                    long relationshipReference = rels.relationshipReference();
                    int type = rels.type();
                    long sourceNodeReference = rels.sourceNodeReference();
                    long targetNodeReference = rels.targetNodeReference();
                    boolean deleted = this.relationshipDelete(relationshipReference);
                    if (this.additionLockVerification && !deleted) {
                        throw new RuntimeException("Relationship chain modified even when node delete lock was held: " + rels);
                    }
                    if (deleted) {
                        deletedRelationshipConsumer.accept(relationshipReference, type, sourceNodeReference, targetNodeReference);
                    }
                    ++deletedRelationships;
                }
            }
        }
        this.nodeDelete(nodeId, false);
        return deletedRelationships;
    }

    private <E extends Exception> long internalRelationshipCreate(RelationshipIdAllocator idAllocator, long sourceNode, int relationshipType, long targetNode, ThrowingLongConsumer<E> checkAfterLocked) throws E, EntityNotFoundException {
        if (relationshipType < 0) {
            throw new IllegalArgumentException("Tried to create relationship with invalid type '%d' between nodes with ids '%d' and '%d'".formatted(relationshipType, sourceNode, targetNode));
        }
        this.ktx.securityAuthorizationHandler().assertAllowsCreateRelationship(this.ktx.securityContext(), this.token::relationshipTypeGetName, relationshipType);
        this.ktx.assertOpen();
        this.sharedSchemaLock(ResourceType.RELATIONSHIP_TYPE, relationshipType);
        this.sharedTokenSchemaLock(ResourceType.RELATIONSHIP_TYPE);
        TransactionState txState = this.ktx.txState();
        boolean sourceNodeAddedInThisBatch = txState.nodeIsAddedInThisBatch(sourceNode);
        boolean targetNodeAddedInTx = sourceNode == targetNode ? sourceNodeAddedInThisBatch : txState.nodeIsAddedInThisBatch(targetNode);
        this.storageLocks.acquireRelationshipCreationLock(this.ktx.lockTracer(), sourceNode, targetNode, sourceNodeAddedInThisBatch, targetNodeAddedInTx);
        if (!sourceNodeAddedInThisBatch) {
            this.assertNodeExists(sourceNode);
        }
        if (targetNode != sourceNode && !targetNodeAddedInTx) {
            this.assertNodeExists(targetNode);
        }
        long id = idAllocator.reserveRelationship(sourceNode, targetNode, relationshipType, sourceNodeAddedInThisBatch, targetNodeAddedInTx);
        this.storageLocks.acquireExclusiveRelationshipLock(this.ktx.lockTracer(), new long[]{id});
        if (checkAfterLocked != null) {
            checkAfterLocked.accept(id);
        }
        txState.relationshipDoCreate(id, relationshipType, sourceNode, targetNode);
        return id;
    }

    public long relationshipCreate(long sourceNode, int relationshipType, long targetNode) throws EntityNotFoundException {
        return this.internalRelationshipCreate((RelationshipIdAllocator)this.commandCreationContext, sourceNode, relationshipType, targetNode, null);
    }

    public void relationshipWithSpecificIdCreate(long relationshipId, long sourceNode, int relationshipType, long targetNode) throws EntityAlreadyExistsException, EntityNotFoundException {
        this.internalRelationshipCreate((sourceNode1, targetNode1, relationshipType1, sourceNodeAddedInTx, targetNodeAddedInTx) -> relationshipId, sourceNode, relationshipType, targetNode, this::assertRelationshipDoesntExist);
        this.ktx.needsHighIdTracking();
    }

    public boolean relationshipDelete(long relationship) {
        this.ktx.assertOpen();
        TransactionState txState = this.ktx.txState();
        boolean relationshipIsAddedInThisBatch = txState.relationshipIsAddedInThisBatch(relationship);
        if (relationshipIsAddedInThisBatch) {
            try {
                this.singleRelationship(relationship);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Relationship " + relationship + " was created in this transaction, but was not found when deleting it");
            }
            this.updater.onDeleteUncreated(this.relationshipCursor, (PropertyCursor)this.propertyCursor);
            txState.relationshipDoDeleteAddedInThisBatch(relationship);
            return true;
        }
        this.kernelRead.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            return false;
        }
        this.sharedSchemaLock(ResourceType.RELATIONSHIP_TYPE, this.relationshipCursor.type());
        this.sharedTokenSchemaLock(ResourceType.RELATIONSHIP_TYPE);
        long sourceNode = this.relationshipCursor.sourceNodeReference();
        long targetNode = this.relationshipCursor.targetNodeReference();
        boolean sourceNodeAddedInBatch = txState.nodeIsAddedInThisBatch(sourceNode);
        boolean targetNodeAddedInBatch = txState.nodeIsAddedInThisBatch(targetNode);
        this.storageLocks.acquireRelationshipDeletionLock(this.ktx.lockTracer(), sourceNode, targetNode, relationship, relationshipIsAddedInThisBatch, sourceNodeAddedInBatch, targetNodeAddedInBatch);
        if (!this.kernelRead.relationshipExists(relationship)) {
            return false;
        }
        this.ktx.securityAuthorizationHandler().assertAllowsDeleteRelationship(this.ktx.securityContext(), this.token::relationshipTypeGetName, this.relationshipCursor.type());
        if (this.transactionStateBehaviour.useIndexCommands()) {
            this.updater.onDeleteUncreated(this.relationshipCursor, (PropertyCursor)this.propertyCursor);
        }
        txState.relationshipDoDelete(relationship, this.relationshipCursor.type(), sourceNode, targetNode);
        return true;
    }

    public boolean nodeAddLabel(long node, int nodeLabel) throws EntityNotFoundException, ConstraintValidationException {
        this.sharedSchemaLock(ResourceType.LABEL, nodeLabel);
        this.sharedTokenSchemaLock(ResourceType.LABEL);
        this.acquireExclusiveNodeLock(node);
        this.storageLocks.acquireNodeLabelChangeLock(this.ktx.lockTracer(), node, nodeLabel);
        this.singleNode(node);
        if (this.nodeCursor.hasLabel(nodeLabel)) {
            return false;
        }
        LongSet removed = this.ktx.txState().nodeStateLabelDiffSets(node).getRemoved();
        if (!removed.contains((long)nodeLabel)) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetLabel(this.ktx.securityContext(), this.token::labelGetName, nodeLabel);
        }
        this.checkConstraintsAndAddLabelToNode(node, nodeLabel);
        return true;
    }

    private void checkConstraintsAndAddLabelToNode(long node, int nodeLabel) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        Collection<IndexDescriptor> indexes = this.checkConstraintsAndGetIndexes(node, nodeLabel);
        this.ktx.txState().nodeDoAddLabel(nodeLabel, node);
        this.updater.onLabelChange(this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL, nodeLabel, indexes);
    }

    private Collection<IndexDescriptor> checkConstraintsAndGetIndexes(long node, int nodeLabel) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        int[] existingPropertyKeyIds;
        if (this.storageReader.hasRelatedSchema(nodeLabel, EntityType.NODE) && (existingPropertyKeyIds = this.loadSortedNodePropertyKeyList()).length > 0) {
            Collection indexes = this.storageReader.valueIndexesGetRelated(new int[]{nodeLabel}, existingPropertyKeyIds, EntityType.NODE);
            for (IndexDescriptor index : indexes) {
                PropertyIndexQuery.ExactPredicate[] propertyValues;
                if (!index.isUnique() || (propertyValues = this.getAllPropertyValues((EntityCursor)this.nodeCursor, index.schema(), -1, Values.NO_VALUE)) == null) continue;
                this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)((UniquenessConstraintDescriptor)this.storageReader.constraintGetForName(index.getName())), index, propertyValues, node);
            }
            return indexes;
        }
        return Collections.emptyList();
    }

    private int[] loadSortedNodePropertyKeyList() {
        this.nodeCursor.properties(this.propertyCursor, PropertySelection.ALL_PROPERTY_KEYS);
        return this.doLoadSortedPropertyKeyList();
    }

    private int[] loadSortedRelationshipPropertyKeyList() {
        this.relationshipCursor.properties(this.propertyCursor, PropertySelection.ALL_PROPERTY_KEYS);
        return this.doLoadSortedPropertyKeyList();
    }

    private int[] doLoadSortedPropertyKeyList() {
        if (!this.propertyCursor.next()) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int[] propertyKeyIds = new int[4];
        int cursor = 0;
        boolean isSorted = true;
        do {
            int key;
            if (cursor == propertyKeyIds.length) {
                propertyKeyIds = Arrays.copyOf(propertyKeyIds, cursor * 2);
            }
            propertyKeyIds[cursor] = key = this.propertyCursor.propertyKey();
            if (cursor > 0 && key < propertyKeyIds[cursor - 1]) {
                isSorted = false;
            }
            ++cursor;
        } while (this.propertyCursor.next());
        if (cursor != propertyKeyIds.length) {
            propertyKeyIds = Arrays.copyOf(propertyKeyIds, cursor);
        }
        if (!isSorted) {
            Arrays.sort(propertyKeyIds);
        }
        return propertyKeyIds;
    }

    private boolean nodeDelete(long node, boolean lock) {
        this.ktx.assertOpen();
        if (this.ktx.hasTxStateWithChanges()) {
            TransactionState state = this.ktx.txState();
            if (state.nodeIsAddedInThisBatch(node)) {
                try {
                    this.singleNode(node);
                }
                catch (EntityNotFoundException e) {
                    throw new IllegalStateException("Node " + node + " was created in this transaction, but was not found when it was about to be deleted");
                }
                this.updater.onDeleteUncreated(this.nodeCursor, (PropertyCursor)this.propertyCursor);
                state.nodeDoDelete(node);
                return true;
            }
            if (state.nodeIsDeletedInThisBatch(node)) {
                return false;
            }
        }
        if (lock) {
            this.storageLocks.acquireNodeDeletionLock((ReadableTransactionState)this.ktx.txState(), this.ktx.lockTracer(), node);
        }
        this.kernelRead.singleNode(node, this.nodeCursor);
        if (this.nodeCursor.next()) {
            this.acquireSharedNodeLabelLocks();
            this.sharedTokenSchemaLock(ResourceType.LABEL);
            this.ktx.securityAuthorizationHandler().assertAllowsDeleteNode(this.ktx.securityContext(), this.token::labelGetName, this.nodeCursor::labels);
            if (this.transactionStateBehaviour.useIndexCommands()) {
                this.updater.onDeleteUncreated(this.nodeCursor, (PropertyCursor)this.propertyCursor);
            }
            this.ktx.txState().nodeDoDelete(node);
            return true;
        }
        return false;
    }

    private int[] acquireSharedNodeLabelLocks() {
        int[] labels = this.nodeCursor.labels().all();
        this.acquireSharedLabelLocks(labels);
        return labels;
    }

    private int acquireSharedRelationshipTypeLock() {
        int relType = this.relationshipCursor.type();
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), ResourceType.RELATIONSHIP_TYPE, new long[]{relType});
        return relType;
    }

    private void singleNode(long node) throws EntityNotFoundException {
        this.kernelRead.singleNode(node, this.nodeCursor);
        if (!this.nodeCursor.next()) {
            throw new EntityNotFoundException(EntityType.NODE, this.ktx.internalTransaction().elementIdMapper().nodeElementId(node));
        }
    }

    private void singleRelationship(long relationship) throws EntityNotFoundException {
        this.kernelRead.singleRelationship(relationship, this.relationshipCursor);
        if (!this.relationshipCursor.next()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, this.ktx.internalTransaction().elementIdMapper().relationshipElementId(relationship));
        }
    }

    private PropertyIndexQuery.ExactPredicate[] getAllPropertyValues(EntityCursor cursor, SchemaDescriptor schema, int changedPropertyKeyId, Value changedValue) {
        int k;
        int[] schemaPropertyIds = schema.getPropertyIds();
        PropertyIndexQuery.ExactPredicate[] values = new PropertyIndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        cursor.properties((PropertyCursor)this.propertyCursor, PropertySelection.selection((int[])schemaPropertyIds));
        while (this.propertyCursor.next()) {
            int entityPropertyId = this.propertyCursor.propertyKey();
            int k2 = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)entityPropertyId);
            if (k2 < 0) continue;
            if (entityPropertyId != -1) {
                values[k2] = PropertyIndexQuery.exact((int)entityPropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = PropertyIndexQuery.exact((int)changedPropertyKeyId, (Object)changedValue);
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private PropertyIndexQuery.ExactPredicate[] getAllPropertyValues(EntityCursor cursor, SchemaDescriptor schema, IntObjectMap<Value> changedProperties) {
        int[] schemaPropertyIds = schema.getPropertyIds();
        PropertyIndexQuery.ExactPredicate[] values = new PropertyIndexQuery.ExactPredicate[schemaPropertyIds.length];
        int nMatched = 0;
        cursor.properties((PropertyCursor)this.propertyCursor, PropertySelection.selection((int[])schemaPropertyIds));
        while (this.propertyCursor.next()) {
            int entityPropertyId = this.propertyCursor.propertyKey();
            int k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)entityPropertyId);
            if (k < 0) continue;
            if (entityPropertyId != -1) {
                values[k] = PropertyIndexQuery.exact((int)entityPropertyId, (Object)this.propertyCursor.propertyValue());
            }
            ++nMatched;
        }
        for (IntObjectPair changedProperty : changedProperties.keyValuesView()) {
            int k;
            int changedPropertyKeyId = changedProperty.getOne();
            if (changedPropertyKeyId == -1 || (k = ArrayUtils.indexOf((int[])schemaPropertyIds, (int)changedPropertyKeyId)) < 0) continue;
            values[k] = PropertyIndexQuery.exact((int)changedPropertyKeyId, (Object)changedProperty.getTwo());
            ++nMatched;
        }
        if (nMatched < values.length) {
            return null;
        }
        return values;
    }

    private void validateNoExistingNodeWithExactValues(IndexBackedConstraintDescriptor constraint, IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] propertyValues, long modifiedNode) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        if (constraint == null || index == null) {
            return;
        }
        long existingNodeId = -1L;
        try (KernelTransaction.Revertable r = this.ktx.overrideWith(this.ktx.securityContext().withMode((AccessMode)AccessMode.Static.FULL));
             DefaultNodeValueIndexCursor valueCursor = this.cursors.allocateNodeValueIndexCursor(this.ktx.cursorContext(), this.memoryTracker);
             IndexReaders indexReaders = new IndexReaders(index, this.kernelRead);){
            this.assertOnlineAndLock(constraint, index, propertyValues);
            this.kernelRead.nodeIndexSeekWithFreshIndexReader(valueCursor, indexReaders.createReader(), propertyValues);
            while (valueCursor.next()) {
                if (valueCursor.nodeReference() == modifiedNode) continue;
                existingNodeId = valueCursor.nodeReference();
                break;
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException((ConstraintDescriptor)constraint, (Throwable)e, (TokenNameLookup)this.token);
        }
        if (existingNodeId != -1L) {
            int[] propertyKeys = Operations.getPropertyIds((PropertyIndexQuery[])propertyValues);
            boolean allowsReadAllProperties = false;
            try (DefaultNodeCursor nodeCursor = this.cursors.allocateNodeCursor(this.ktx.cursorContext(), this.memoryTracker);
                 DefaultPropertyCursor propertyCursor = this.cursors.allocatePropertyCursor(this.ktx.cursorContext(), this.memoryTracker);){
                nodeCursor.single(existingNodeId, this.kernelRead, this.ktx, this.accessModeProvider);
                if (nodeCursor.next()) {
                    nodeCursor.properties(propertyCursor, PropertySelection.selection((int[])propertyKeys));
                    int nPropertiesRead = 0;
                    while (propertyCursor.next()) {
                        ++nPropertiesRead;
                    }
                    if (nPropertiesRead == propertyKeys.length) {
                        allowsReadAllProperties = true;
                    }
                }
            }
            throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(index.schema(), allowsReadAllProperties ? existingNodeId : -1L, -1L, PropertyIndexQuery.asValueTuple((PropertyIndexQuery.ExactPredicate[])propertyValues)), (TokenNameLookup)this.token);
        }
    }

    private static int[] getPropertyIds(PropertyIndexQuery[] queries) {
        int[] propertyIds = new int[queries.length];
        for (int i = 0; i < queries.length; ++i) {
            propertyIds[i] = queries[i].propertyKeyId();
        }
        return propertyIds;
    }

    private void assertOnlineAndLock(IndexBackedConstraintDescriptor constraint, IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] propertyValues) throws IndexNotFoundKernelException, IndexBrokenKernelException, UnableToValidateConstraintException {
        this.assertIndexOnline(index);
        SchemaDescriptor schema = index.schema();
        int[] entityTokenIds = schema.getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new UnableToValidateConstraintException((ConstraintDescriptor)constraint, (Throwable)((Object)new AssertionError((Object)String.format("Constraint indexes are not expected to be multi-token indexes, but the constraint %s was referencing an index with the following schema: %s.", constraint.userDescription((TokenNameLookup)this.token), schema.userDescription((TokenNameLookup)this.token)))), (TokenNameLookup)this.token);
        }
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), ResourceType.INDEX_ENTRY, new long[]{ResourceIds.indexEntryResourceId(entityTokenIds[0], propertyValues)});
    }

    private void validateNoExistingRelWithExactValues(IndexBackedConstraintDescriptor constraint, IndexDescriptor index, PropertyIndexQuery.ExactPredicate[] propertyValues, long modifiedRel) throws UniquePropertyValueValidationException, UnableToValidateConstraintException {
        if (constraint == null || index == null) {
            return;
        }
        long existingRelationshipId = -1L;
        try (KernelTransaction.Revertable r = this.ktx.overrideWith(this.ktx.securityContext().withMode((AccessMode)AccessMode.Static.FULL));
             DefaultRelationshipValueIndexCursor valueCursor = this.cursors.allocateRelationshipValueIndexCursor(this.ktx.cursorContext(), this.memoryTracker);
             IndexReaders indexReaders = new IndexReaders(index, this.kernelRead);){
            this.assertOnlineAndLock(constraint, index, propertyValues);
            this.kernelRead.relationshipIndexSeekWithFreshIndexReader(valueCursor, indexReaders.createReader(), propertyValues);
            while (valueCursor.next()) {
                if (valueCursor.relationshipReference() == modifiedRel) continue;
                existingRelationshipId = valueCursor.relationshipReference();
                break;
            }
        }
        catch (IndexNotApplicableKernelException | IndexNotFoundKernelException | IndexBrokenKernelException e) {
            throw new UnableToValidateConstraintException((ConstraintDescriptor)constraint, (Throwable)e, (TokenNameLookup)this.token);
        }
        if (existingRelationshipId != -1L) {
            int[] propertyKeys = Operations.getPropertyIds((PropertyIndexQuery[])propertyValues);
            boolean allowsReadAllProperties = false;
            try (DefaultRelationshipScanCursor relCursor = (DefaultRelationshipScanCursor)this.cursors.allocateRelationshipScanCursor(this.ktx.cursorContext(), this.memoryTracker);
                 DefaultPropertyCursor propertyCursor = this.cursors.allocatePropertyCursor(this.ktx.cursorContext(), this.memoryTracker);){
                relCursor.single(existingRelationshipId, this.kernelRead, this.ktx, this.accessModeProvider);
                if (relCursor.next()) {
                    relCursor.properties(propertyCursor, PropertySelection.selection((int[])propertyKeys));
                    int nPropertiesRead = 0;
                    while (propertyCursor.next()) {
                        ++nPropertiesRead;
                    }
                    if (nPropertiesRead == propertyKeys.length) {
                        allowsReadAllProperties = true;
                    }
                }
            }
            throw new UniquePropertyValueValidationException(constraint, ConstraintValidationException.Phase.VALIDATION, new IndexEntryConflictException(index.schema(), allowsReadAllProperties ? existingRelationshipId : -1L, -1L, PropertyIndexQuery.asValueTuple((PropertyIndexQuery.ExactPredicate[])propertyValues)), (TokenNameLookup)this.token);
        }
    }

    private void assertIndexOnline(IndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        if (this.schemaRead.indexGetState(descriptor) != InternalIndexState.ONLINE) {
            throw new IndexBrokenKernelException(this.schemaRead.indexGetFailure(descriptor));
        }
    }

    public boolean nodeRemoveLabel(long node, int labelId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.storageLocks.acquireNodeLabelChangeLock(this.ktx.lockTracer(), node, labelId);
        this.ktx.assertOpen();
        this.singleNode(node);
        if (!this.nodeCursor.hasLabel(labelId)) {
            return false;
        }
        LongSet added = this.ktx.txState().nodeStateLabelDiffSets(node).getAdded();
        if (!added.contains((long)labelId)) {
            this.ktx.securityAuthorizationHandler().assertAllowsRemoveLabel(this.ktx.securityContext(), this.token::labelGetName, labelId);
        }
        this.sharedSchemaLock(ResourceType.LABEL, labelId);
        this.sharedTokenSchemaLock(ResourceType.LABEL);
        this.ktx.txState().nodeDoRemoveLabel(labelId, node);
        if (this.storageReader.hasRelatedSchema(labelId, EntityType.NODE)) {
            int[] existingPropertyKeyIds = this.loadSortedNodePropertyKeyList();
            this.updater.onLabelChange(this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL, labelId, this.storageReader.valueIndexesGetRelated(new int[]{labelId}, existingPropertyKeyIds, EntityType.NODE));
        }
        return true;
    }

    public void nodeSetProperty(long node, int propertyKey, Value value) throws EntityNotFoundException, ConstraintValidationException {
        assert (value != Values.NO_VALUE);
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        int[] labels = this.nodeCursor.labelsAndProperties(this.propertyCursor, PropertySelection.selection((int)propertyKey)).all();
        Value existingValue = this.propertyCursor.next() ? this.propertyCursor.propertyValue() : Values.NO_VALUE;
        this.acquireSharedLabelLocks(labels);
        int[] existingPropertyKeyIds = null;
        boolean hasRelatedSchema = this.storageReader.hasRelatedSchema(labels, propertyKey, EntityType.NODE);
        if (hasRelatedSchema) {
            existingPropertyKeyIds = this.loadSortedNodePropertyKeyList();
        }
        if (existingValue == Values.NO_VALUE) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)Labels.from(labels), propertyKey);
            if (hasRelatedSchema) {
                this.checkUniquenessConstraints(node, propertyKey, value, labels, existingPropertyKeyIds);
            }
            this.ktx.txState().nodeDoAddProperty(node, propertyKey, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyAdd(this.nodeCursor, (PropertyCursor)this.propertyCursor, labels, propertyKey, existingPropertyKeyIds, value);
            }
        } else if (Operations.propertyHasChanged(value, existingValue)) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)Labels.from(labels), propertyKey);
            if (hasRelatedSchema) {
                this.checkUniquenessConstraints(node, propertyKey, value, labels, existingPropertyKeyIds);
            }
            this.ktx.txState().nodeDoChangeProperty(node, propertyKey, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyChange(this.nodeCursor, (PropertyCursor)this.propertyCursor, labels, propertyKey, existingPropertyKeyIds, existingValue, value);
            }
        }
    }

    public void nodeApplyChanges(long node, IntSet addedLabels, IntSet removedLabels, IntObjectMap<Value> properties) throws EntityNotFoundException, ConstraintValidationException {
        Value existingValue;
        int[] existingLabels;
        assert (PrimitiveArrays.intersect((int[])addedLabels.toSortedArray(), (int[])removedLabels.toSortedArray()).length == 0);
        this.ktx.assertOpen();
        if (!addedLabels.isEmpty() || !removedLabels.isEmpty()) {
            addedLabels.forEach((IntProcedure & Serializable)addedLabelId -> {
                this.sharedSchemaLock(ResourceType.LABEL, addedLabelId);
                this.storageLocks.acquireNodeLabelChangeLock(this.ktx.lockTracer(), node, addedLabelId);
            });
            removedLabels.forEach((IntProcedure & Serializable)removedLabelId -> {
                this.sharedSchemaLock(ResourceType.LABEL, removedLabelId);
                this.storageLocks.acquireNodeLabelChangeLock(this.ktx.lockTracer(), node, removedLabelId);
            });
            this.sharedTokenSchemaLock(ResourceType.LABEL);
        }
        this.acquireExclusiveNodeLock(node);
        this.singleNode(node);
        MutableIntObjectMap existingValuesForChangedProperties = null;
        if (!properties.isEmpty()) {
            existingLabels = this.nodeCursor.labelsAndProperties(this.propertyCursor, PropertySelection.selection((int[])properties.keySet().toArray())).all();
            existingValuesForChangedProperties = IntObjectMaps.mutable.empty();
            while (this.propertyCursor.next()) {
                existingValuesForChangedProperties.put(this.propertyCursor.propertyKey(), (Object)this.propertyCursor.propertyValue());
            }
        } else {
            existingLabels = this.nodeCursor.labels().all();
        }
        this.acquireSharedLabelLocks(existingLabels);
        int[] labelsAfter = Operations.combineLabelIds(existingLabels, addedLabels, removedLabels);
        int[] existingPropertyKeyIds = this.loadSortedNodePropertyKeyList();
        MutableIntSet afterPropertyKeyIdsSet = IntSets.mutable.of(existingPropertyKeyIds);
        RichIterable propertiesKeyValueView = properties.keyValuesView();
        MutableIntSet removedPropertyKeyIdsSet = null;
        MutableIntSet changedPropertyKeyIdsSet = null;
        for (IntObjectPair property : propertiesKeyValueView) {
            int key = property.getOne();
            Value value = (Value)property.getTwo();
            if (value == Values.NO_VALUE) {
                if (removedPropertyKeyIdsSet == null) {
                    removedPropertyKeyIdsSet = IntSets.mutable.empty();
                }
                removedPropertyKeyIdsSet.add(key);
                afterPropertyKeyIdsSet.remove(key);
                continue;
            }
            afterPropertyKeyIdsSet.add(key);
            Value existingValue2 = (Value)existingValuesForChangedProperties.get(key);
            if (existingValue2 != null && !Operations.propertyHasChanged(value, existingValue2)) continue;
            if (changedPropertyKeyIdsSet == null) {
                changedPropertyKeyIdsSet = IntSets.mutable.empty();
            }
            changedPropertyKeyIdsSet.add(key);
        }
        int[] afterPropertyKeyIds = afterPropertyKeyIdsSet.toSortedArray();
        int[] changedPropertyKeyIds = changedPropertyKeyIdsSet != null ? changedPropertyKeyIdsSet.toSortedArray() : ArrayUtils.EMPTY_INT_ARRAY;
        int[] uniquenessPropertiesCheck = addedLabels.isEmpty() ? changedPropertyKeyIds : afterPropertyKeyIds;
        Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(Operations.combineLabelIds(ArrayUtils.EMPTY_INT_ARRAY, addedLabels, (IntSet)IntSets.immutable.empty()), labelsAfter, uniquenessPropertiesCheck, false, EntityType.NODE);
        SchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), -1, afterPropertyKeyIds, this.transactionStateBehaviour, constraint -> this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)constraint, this.storageReader.indexGetForName(constraint.getName()), this.getAllPropertyValues((EntityCursor)this.nodeCursor, constraint.schema(), properties), node));
        if (!removedLabels.isEmpty()) {
            LongSet added = this.ktx.txState().nodeStateLabelDiffSets(node).getAdded();
            IntIterator removedLabelsIterator = removedLabels.intIterator();
            while (removedLabelsIterator.hasNext()) {
                int removedLabelId2 = removedLabelsIterator.next();
                if (!added.contains((long)removedLabelId2)) {
                    this.ktx.securityAuthorizationHandler().assertAllowsRemoveLabel(this.ktx.securityContext(), this.token::labelGetName, removedLabelId2);
                }
                if (!ArrayUtils.contains((int[])existingLabels, (int)removedLabelId2)) continue;
                this.ktx.txState().nodeDoRemoveLabel(removedLabelId2, node);
                if (!this.storageReader.hasRelatedSchema(removedLabelId2, EntityType.NODE)) continue;
                this.updater.onLabelChange(this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.REMOVED_LABEL, removedLabelId2, this.storageReader.valueIndexesGetRelated(new int[]{removedLabelId2}, existingPropertyKeyIds, EntityType.NODE));
            }
        }
        if (removedPropertyKeyIdsSet != null) {
            int[] existingLabelsMinusRemovedArray = removedLabels.isEmpty() ? existingLabels : Operations.combineLabelIds(existingLabels, (IntSet)IntSets.immutable.empty(), removedLabels);
            Labels existingLabelsMinusRemoved = Labels.from(existingLabelsMinusRemovedArray);
            for (int key : removedPropertyKeyIdsSet.toArray()) {
                int existingPropertyKeyIdIndex = ArrayUtils.indexOf((int[])existingPropertyKeyIds, (int)key);
                if (existingPropertyKeyIdIndex < 0) continue;
                existingValue = (Value)existingValuesForChangedProperties.getIfAbsent(key, (Function0 & Serializable)() -> Values.NO_VALUE);
                this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)existingLabelsMinusRemoved, key);
                this.ktx.txState().nodeDoRemoveProperty(node, key);
                existingPropertyKeyIds = ArrayUtils.remove((int[])existingPropertyKeyIds, (int)existingPropertyKeyIdIndex);
                if (!this.storageReader.hasRelatedSchema(existingLabelsMinusRemovedArray, key, EntityType.NODE)) continue;
                this.updater.onPropertyRemove(this.nodeCursor, (PropertyCursor)this.propertyCursor, existingLabelsMinusRemovedArray, key, existingPropertyKeyIds, existingValue);
            }
        }
        if (!addedLabels.isEmpty()) {
            IntIterator addedLabelsIterator = addedLabels.intIterator();
            while (addedLabelsIterator.hasNext()) {
                int addedLabelId2 = addedLabelsIterator.next();
                if (ArrayUtils.contains((int[])existingLabels, (int)addedLabelId2)) continue;
                LongSet removed = this.ktx.txState().nodeStateLabelDiffSets(node).getRemoved();
                if (!removed.contains((long)addedLabelId2)) {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetLabel(this.ktx.securityContext(), this.token::labelGetName, addedLabelId2);
                }
                this.ktx.txState().nodeDoAddLabel(addedLabelId2, node);
                if (!this.storageReader.hasRelatedSchema(addedLabelId2, EntityType.NODE)) continue;
                this.updater.onLabelChange(this.nodeCursor, this.propertyCursor, IndexTxStateUpdater.LabelChangeType.ADDED_LABEL, addedLabelId2, this.storageReader.valueIndexesGetRelated(new int[]{addedLabelId2}, existingPropertyKeyIds, EntityType.NODE));
            }
        }
        if (changedPropertyKeyIdsSet != null) {
            Labels labelsAfterSet = Labels.from(labelsAfter);
            MutableIntSet existingPropertyKeyIdsBeforeChange = IntSets.mutable.of(existingPropertyKeyIds);
            for (int key : changedPropertyKeyIds) {
                Value value = (Value)properties.get(key);
                existingValue = (Value)existingValuesForChangedProperties.getIfAbsent(key, (Function0 & Serializable)() -> Values.NO_VALUE);
                if (existingValue == Values.NO_VALUE) {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)labelsAfterSet, key);
                    this.ktx.txState().nodeDoAddProperty(node, key, value);
                    hasRelatedSchema = this.storageReader.hasRelatedSchema(labelsAfter, key, EntityType.NODE);
                    if (hasRelatedSchema) {
                        this.updater.onPropertyAdd(this.nodeCursor, (PropertyCursor)this.propertyCursor, labelsAfter, key, existingPropertyKeyIdsBeforeChange.toSortedArray(), value);
                    }
                } else {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)labelsAfterSet, key);
                    this.ktx.txState().nodeDoChangeProperty(node, key, value);
                    hasRelatedSchema = this.storageReader.hasRelatedSchema(labelsAfter, key, EntityType.NODE);
                    if (hasRelatedSchema) {
                        this.updater.onPropertyChange(this.nodeCursor, (PropertyCursor)this.propertyCursor, labelsAfter, key, existingPropertyKeyIdsBeforeChange.toSortedArray(), existingValue, value);
                    }
                }
                existingPropertyKeyIdsBeforeChange.add(key);
            }
        }
    }

    public void relationshipApplyChanges(long relationship, IntObjectMap<Value> properties) throws EntityNotFoundException, ConstraintValidationException {
        Object afterPropertyKeyIds;
        int[] changedPropertyKeyIds;
        this.ktx.assertOpen();
        this.acquireExclusiveRelationshipLock(relationship);
        if (properties.isEmpty()) {
            return;
        }
        this.singleRelationship(relationship);
        int type = this.acquireSharedRelationshipTypeLock();
        MutableIntObjectMap existingValuesForChangedProperties = IntObjectMaps.mutable.empty();
        this.relationshipCursor.properties(this.propertyCursor, PropertySelection.selection((int[])properties.keySet().toArray()));
        while (this.propertyCursor.next()) {
            existingValuesForChangedProperties.put(this.propertyCursor.propertyKey(), (Object)this.propertyCursor.propertyValue());
        }
        int[] existingPropertyKeyIds = this.loadSortedRelationshipPropertyKeyList();
        MutableIntSet afterPropertyKeyIdsSet = IntSets.mutable.of(existingPropertyKeyIds);
        boolean hasPropertyRemovals = false;
        MutableIntSet changedPropertyKeyIdsSet = null;
        RichIterable propertiesKeyValueView = properties.keyValuesView();
        for (IntObjectPair property : propertiesKeyValueView) {
            int key = property.getOne();
            Value value = (Value)property.getTwo();
            if (value == Values.NO_VALUE) {
                hasPropertyRemovals = true;
                afterPropertyKeyIdsSet.remove(key);
                continue;
            }
            afterPropertyKeyIdsSet.add(key);
            Value existingValue = (Value)existingValuesForChangedProperties.get(key);
            if (existingValue != null && !Operations.propertyHasChanged(value, existingValue)) continue;
            if (changedPropertyKeyIdsSet == null) {
                changedPropertyKeyIdsSet = IntSets.mutable.empty();
            }
            changedPropertyKeyIdsSet.add(key);
        }
        int[] nArray = changedPropertyKeyIds = changedPropertyKeyIdsSet != null ? changedPropertyKeyIdsSet.toSortedArray() : ArrayUtils.EMPTY_INT_ARRAY;
        if (changedPropertyKeyIdsSet != null) {
            afterPropertyKeyIds = afterPropertyKeyIdsSet.toSortedArray();
            Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(new int[]{type}, changedPropertyKeyIds, EntityType.RELATIONSHIP);
            SchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), -1, (int[])afterPropertyKeyIds, this.transactionStateBehaviour, constraint -> this.validateNoExistingRelWithExactValues((IndexBackedConstraintDescriptor)constraint, this.storageReader.indexGetForName(constraint.getName()), this.getAllPropertyValues((EntityCursor)this.relationshipCursor, constraint.schema(), properties), relationship));
        }
        if (hasPropertyRemovals) {
            afterPropertyKeyIds = propertiesKeyValueView.iterator();
            while (afterPropertyKeyIds.hasNext()) {
                int existingPropertyKeyIdIndex;
                IntObjectPair property = (IntObjectPair)afterPropertyKeyIds.next();
                int key = property.getOne();
                Value value = (Value)property.getTwo();
                if (value != Values.NO_VALUE || (existingPropertyKeyIdIndex = ArrayUtils.indexOf((int[])existingPropertyKeyIds, (int)key)) < 0) continue;
                Value existingValue = (Value)existingValuesForChangedProperties.getIfAbsent(key, (Function0 & Serializable)() -> Values.NO_VALUE);
                this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, key);
                this.ktx.txState().relationshipDoRemoveProperty(relationship, type, this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), key);
                existingPropertyKeyIds = ArrayUtils.remove((int[])existingPropertyKeyIds, (int)existingPropertyKeyIdIndex);
                if (!this.storageReader.hasRelatedSchema(new int[]{type}, key, EntityType.RELATIONSHIP)) continue;
                this.updater.onPropertyRemove(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, key, existingPropertyKeyIds, existingValue);
            }
        }
        if (changedPropertyKeyIdsSet != null) {
            MutableIntSet existingPropertyKeyIdsBeforeChange = IntSets.mutable.of(existingPropertyKeyIds);
            for (int key : changedPropertyKeyIds) {
                Value value = (Value)properties.get(key);
                Value existingValue = (Value)existingValuesForChangedProperties.getIfAbsent(key, (Function0 & Serializable)() -> Values.NO_VALUE);
                if (existingValue == Values.NO_VALUE) {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, key);
                    this.ktx.txState().relationshipDoReplaceProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), key, Values.NO_VALUE, value);
                    hasRelatedSchema = this.storageReader.hasRelatedSchema(new int[]{type}, key, EntityType.RELATIONSHIP);
                    if (hasRelatedSchema) {
                        this.updater.onPropertyAdd(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, key, existingPropertyKeyIdsBeforeChange.toSortedArray(), value);
                    }
                } else {
                    this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, key);
                    this.ktx.txState().relationshipDoReplaceProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), key, existingValue, value);
                    hasRelatedSchema = this.storageReader.hasRelatedSchema(new int[]{type}, key, EntityType.RELATIONSHIP);
                    if (hasRelatedSchema) {
                        this.updater.onPropertyChange(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, key, existingPropertyKeyIdsBeforeChange.toSortedArray(), existingValue, value);
                    }
                }
                existingPropertyKeyIdsBeforeChange.add(key);
            }
        }
    }

    private static int[] combineLabelIds(int[] existingLabels, IntSet addedLabels, IntSet removedLabels) {
        if (addedLabels.isEmpty() && removedLabels.isEmpty()) {
            return existingLabels;
        }
        MutableIntSet result = IntSets.mutable.of(existingLabels);
        addedLabels.forEach(arg_0 -> ((MutableIntSet)result).add(arg_0));
        removedLabels.forEach(arg_0 -> ((MutableIntSet)result).remove(arg_0));
        return result.toSortedArray();
    }

    private String resolvePropertyKey(int propertyKey) {
        String propKeyName;
        try {
            propKeyName = this.token.propertyKeyName(propertyKey);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            propKeyName = "<unknown>";
        }
        return propKeyName;
    }

    private void checkUniquenessConstraints(long node, int propertyKey, Value value, int[] labels, int[] existingPropertyKeyIds) throws ConstraintValidationException {
        Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(labels, propertyKey, EntityType.NODE);
        SchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), propertyKey, existingPropertyKeyIds, this.transactionStateBehaviour, constraint -> this.validateNoExistingNodeWithExactValues((IndexBackedConstraintDescriptor)constraint, this.storageReader.indexGetForName(constraint.getName()), this.getAllPropertyValues((EntityCursor)this.nodeCursor, constraint.schema(), propertyKey, value), node));
    }

    private void checkRelationshipUniquenessConstraints(long rel, int propertyKey, Value value, int type, int[] existingPropertyKeyIds) throws ConstraintValidationException {
        Collection uniquenessConstraints = this.storageReader.uniquenessConstraintsGetRelated(new int[]{type}, propertyKey, EntityType.RELATIONSHIP);
        SchemaMatcher.onMatchingSchema(uniquenessConstraints.iterator(), propertyKey, existingPropertyKeyIds, this.transactionStateBehaviour, constraint -> this.validateNoExistingRelWithExactValues((IndexBackedConstraintDescriptor)constraint, this.storageReader.indexGetForName(constraint.getName()), this.getAllPropertyValues((EntityCursor)this.relationshipCursor, constraint.schema(), propertyKey, value), rel));
    }

    public Value nodeRemoveProperty(long node, int propertyKey) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(node);
        this.ktx.assertOpen();
        this.singleNode(node);
        Value existingValue = this.readNodeProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            int[] labels = this.acquireSharedNodeLabelLocks();
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (TokenSet)Labels.from(labels), propertyKey);
            this.ktx.txState().nodeDoRemoveProperty(node, propertyKey);
            if (this.storageReader.hasRelatedSchema(labels, propertyKey, EntityType.NODE)) {
                this.updater.onPropertyRemove(this.nodeCursor, (PropertyCursor)this.propertyCursor, labels, propertyKey, this.loadSortedNodePropertyKeyList(), existingValue);
            }
        }
        return existingValue;
    }

    public void relationshipSetProperty(long relationship, int propertyKey, Value value) throws EntityNotFoundException, ConstraintValidationException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        int type = this.acquireSharedRelationshipTypeLock();
        Value existingValue = this.readRelationshipProperty(propertyKey);
        int[] existingPropertyKeyIds = null;
        boolean hasRelatedSchema = this.storageReader.hasRelatedSchema(new int[]{type}, propertyKey, EntityType.RELATIONSHIP);
        if (hasRelatedSchema) {
            existingPropertyKeyIds = this.loadSortedRelationshipPropertyKeyList();
        }
        if (existingValue == Values.NO_VALUE) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, propertyKey);
            if (hasRelatedSchema) {
                this.checkRelationshipUniquenessConstraints(relationship, propertyKey, value, type, existingPropertyKeyIds);
            }
            this.ktx.txState().relationshipDoReplaceProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), propertyKey, Values.NO_VALUE, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyAdd(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, propertyKey, existingPropertyKeyIds, value);
            }
            return;
        }
        if (Operations.propertyHasChanged(existingValue, value)) {
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, propertyKey);
            if (hasRelatedSchema) {
                this.checkRelationshipUniquenessConstraints(relationship, propertyKey, value, type, existingPropertyKeyIds);
            }
            this.ktx.txState().relationshipDoReplaceProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), propertyKey, existingValue, value);
            if (hasRelatedSchema) {
                this.updater.onPropertyChange(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, propertyKey, existingPropertyKeyIds, existingValue, value);
            }
        }
    }

    public Value relationshipRemoveProperty(long relationship, int propertyKey) throws EntityNotFoundException {
        this.acquireExclusiveRelationshipLock(relationship);
        this.ktx.assertOpen();
        this.singleRelationship(relationship);
        Value existingValue = this.readRelationshipProperty(propertyKey);
        if (existingValue != Values.NO_VALUE) {
            int type = this.acquireSharedRelationshipTypeLock();
            this.ktx.securityAuthorizationHandler().assertAllowsSetProperty(this.ktx.securityContext(), this::resolvePropertyKey, (long)type, propertyKey);
            this.ktx.txState().relationshipDoRemoveProperty(relationship, this.relationshipCursor.type(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.targetNodeReference(), propertyKey);
            if (this.storageReader.hasRelatedSchema(new int[]{type}, propertyKey, EntityType.RELATIONSHIP)) {
                this.updater.onPropertyRemove(this.relationshipCursor, (PropertyCursor)this.propertyCursor, type, propertyKey, this.loadSortedRelationshipPropertyKeyList(), existingValue);
            }
        }
        return existingValue;
    }

    private Value readNodeProperty(int propertyKey) {
        this.nodeCursor.properties(this.propertyCursor, PropertySelection.selection((int)propertyKey));
        return this.propertyCursor.next() ? this.propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    private Value readRelationshipProperty(int propertyKey) {
        this.relationshipCursor.properties(this.propertyCursor, PropertySelection.selection((int)propertyKey));
        return this.propertyCursor.next() ? this.propertyCursor.propertyValue() : Values.NO_VALUE;
    }

    public CursorFactory cursors() {
        return this.cursors;
    }

    public void release() {
        if (this.nodeCursor != null) {
            this.nodeCursor.close();
            this.nodeCursor = null;
        }
        if (this.restrictedNodeCursor != null) {
            this.restrictedNodeCursor.close();
            this.restrictedNodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor = null;
        }
        if (this.restrictedPropertyCursor != null) {
            this.restrictedPropertyCursor.close();
            this.restrictedPropertyCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor = null;
        }
        if (this.restrictedRelationshipCursor != null) {
            this.restrictedRelationshipCursor.close();
            this.restrictedRelationshipCursor = null;
        }
        this.cursors.assertClosed();
        this.cursors.release();
    }

    public Token token() {
        return this.token;
    }

    public DefaultNodeCursor nodeCursor() {
        return this.restrictedNodeCursor;
    }

    public DefaultRelationshipScanCursor relationshipCursor() {
        return this.restrictedRelationshipCursor;
    }

    public DefaultPropertyCursor propertyCursor() {
        return this.restrictedPropertyCursor;
    }

    public IndexProviderDescriptor indexProviderByName(String providerName) {
        this.ktx.assertOpen();
        return this.indexProviders.indexProviderByName(providerName);
    }

    public IndexType indexTypeByProviderName(String providerName) {
        this.ktx.assertOpen();
        return this.indexProviders.indexTypeByProviderName(providerName);
    }

    public List<IndexProviderDescriptor> indexProvidersByType(IndexType indexType) {
        this.ktx.assertOpen();
        return this.indexProviders.indexProvidersByType(indexType);
    }

    public IndexDescriptor indexCreate(IndexPrototype prototype) throws KernelException {
        prototype = this.useLatestIndexProviderVersion(prototype);
        IndexType indexType = prototype.getIndexType();
        this.exclusiveSchemaLock(prototype.schema());
        if (indexType == IndexType.VECTOR) {
            switch (prototype.schema().entityType()) {
                case NODE: {
                    this.assertSupportedInVersion(KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED, "Failed to create node vector index.", new Object[0]);
                    break;
                }
                case RELATIONSHIP: {
                    boolean supported = true;
                    IndexProviderDescriptor descriptor = prototype.getIndexProvider();
                    VectorIndexVersion version = VectorIndexVersion.fromDescriptor((IndexProviderDescriptor)descriptor);
                    StringBuilder unsupportedMessage = new StringBuilder().append("Failed to create relationship vector index.");
                    if (version == VectorIndexVersion.V1_0) {
                        supported = false;
                        IndexProviderDescriptor latestDescriptor = VectorIndexVersion.latestSupportedVersion((KernelVersion)this.dbmsRuntimeVersionProvider.getVersion().kernelVersion()).descriptor();
                        unsupportedMessage.append(" Relationship vector indexes with provider '").append(descriptor.name()).append("' are not supported");
                        if (!latestDescriptor.equals((Object)descriptor)) {
                            unsupportedMessage.append(", use a newer vector index provider such as '").append(latestDescriptor.name()).append('\'');
                        }
                        unsupportedMessage.append('.');
                    }
                    if (supported &= this.checkSupportedInVerson(unsupportedMessage, KernelVersion.VERSION_VECTOR_2_INTRODUCED)) break;
                    throw new UnsupportedOperationException(unsupportedMessage.toString());
                }
            }
        }
        this.assertValidDescriptor(prototype.schema(), SchemaKernelException.OperationContext.INDEX_CREATION);
        if ((indexType == IndexType.TEXT || indexType == IndexType.POINT || indexType == IndexType.VECTOR) && prototype.schema().getPropertyIds().length > 1) {
            throw new UnsupportedOperationException("Composite indexes are not supported for " + indexType.name() + " index type.");
        }
        if (indexType == IndexType.VECTOR) {
            prototype.getIndexConfig().entries().asLazy().collect(Pair::getOne).collect(arg_0 -> ((ImmutableMap)SettingsAccessor.INDEX_SETTING_LOOKUP).get(arg_0)).collectIf((Predicate)Predicates.in((Iterable)VectorIndexConfigUtils.INDEX_SETTING_INTRODUCED_VERSIONS.keysView()), arg_0 -> ((ImmutableSortedMap)VectorIndexConfigUtils.INDEX_SETTING_INTRODUCED_VERSIONS).get(arg_0)).maxOptional().ifPresent(kernelVersion -> this.assertSupportedInVersion((KernelVersion)kernelVersion, "Failed to create vector index with provided settings.", new Object[0]));
        }
        prototype = this.ensureIndexPrototypeHasName(prototype);
        String name = (String)prototype.getName().orElseThrow();
        this.ktx.assertOpen();
        this.exclusiveSchemaLock(prototype.schema());
        this.exclusiveSchemaNameLock(name);
        this.assertNoBlockingSchemaRulesExists(prototype);
        return this.indexDoCreate(prototype);
    }

    public IndexDescriptor indexUniqueCreate(IndexPrototype prototype) {
        return this.indexDoCreate(prototype);
    }

    private IndexDescriptor indexDoCreate(IndexPrototype prototype) {
        prototype = this.indexProviders.validateIndexPrototype(prototype);
        TransactionState transactionState = this.ktx.txState();
        long schemaRecordId = this.commandCreationContext.reserveSchema();
        IndexDescriptor index = prototype.materialise(schemaRecordId);
        index = this.indexProviders.completeConfiguration(index);
        transactionState.indexDoAdd(index);
        return index;
    }

    private IndexPrototype ensureIndexPrototypeHasName(IndexPrototype prototype) {
        return prototype.getName().isEmpty() ? prototype.withName(this.generateNameFrom((SchemaDescriptorSupplier)prototype)) : prototype;
    }

    private IndexPrototype useLatestIndexProviderVersion(IndexPrototype prototype) {
        IndexProviderDescriptor indexProviderDescriptor;
        if (this.alwaysUseLatestIndexProvider || prototype.getIndexProvider() == AllIndexProviderDescriptors.UNDECIDED) {
            switch (prototype.getIndexType()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case LOOKUP: {
                    indexProviderDescriptor = this.indexProviders.getTokenIndexProvider();
                    break;
                }
                case FULLTEXT: {
                    indexProviderDescriptor = this.indexProviders.getFulltextProvider();
                    break;
                }
                case TEXT: {
                    indexProviderDescriptor = this.indexProviders.getTextIndexProvider();
                    break;
                }
                case RANGE: {
                    indexProviderDescriptor = this.indexProviders.getDefaultProvider();
                    break;
                }
                case POINT: {
                    indexProviderDescriptor = this.indexProviders.getPointIndexProvider();
                    break;
                }
                case VECTOR: {
                    indexProviderDescriptor = this.indexProviders.getVectorIndexProvider();
                    break;
                }
            }
        } else {
            indexProviderDescriptor = prototype.getIndexProvider();
        }
        IndexProviderDescriptor indexProviderDescriptor2 = indexProviderDescriptor;
        IndexProvider indexProvider = this.indexProviders.getIndexProvider(indexProviderDescriptor2);
        this.assertSupportedInVersion(indexProvider.getMinimumRequiredVersion(), "Failed to create index with provider '%s'.", indexProviderDescriptor2.name());
        return prototype.withIndexProvider(indexProviderDescriptor2);
    }

    public void indexDrop(IndexDescriptor index) throws SchemaKernelException {
        if (index == IndexDescriptor.NO_INDEX) {
            throw new DropIndexFailureException("No index was specified.");
        }
        this.exclusiveSchemaLock(index.schema());
        this.exclusiveSchemaNameLock(index.getName());
        this.assertIndexExistsForDrop(index);
        if (index.isUnique() && this.schemaRead.indexGetOwningUniquenessConstraintId(index) != null) {
            IndexBelongsToConstraintException cause = new IndexBelongsToConstraintException(index.schema());
            throw new DropIndexFailureException("Unable to drop index: " + cause.getUserMessage((TokenNameLookup)this.token), (Throwable)((Object)cause));
        }
        this.ktx.txState().indexDoDrop(index);
    }

    private void assertIndexExistsForDrop(IndexDescriptor index) throws DropIndexFailureException {
        try {
            this.schemaRead.assertIndexExists(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw new DropIndexFailureException("Unable to drop index: " + e.getUserMessage((TokenNameLookup)this.token), e);
        }
    }

    public void indexDrop(String indexName) throws SchemaKernelException {
        this.exclusiveSchemaNameLock(indexName);
        IndexDescriptor index = this.schemaRead.indexGetForName(indexName);
        if (index == IndexDescriptor.NO_INDEX) {
            throw new DropIndexFailureException("Unable to drop index called `" + indexName + "`. There is no such index.");
        }
        this.exclusiveSchemaLock(index.schema());
        this.assertIndexExistsForDrop(index);
        if (index.isUnique() && this.schemaRead.indexGetOwningUniquenessConstraintId(index) != null) {
            IndexBelongsToConstraintException cause = new IndexBelongsToConstraintException(indexName, index.schema());
            throw new DropIndexFailureException("Unable to drop index: " + cause.getUserMessage((TokenNameLookup)this.token), (Throwable)((Object)cause));
        }
        this.ktx.txState().indexDoDrop(index);
    }

    public ConstraintDescriptor uniquePropertyConstraintCreate(IndexPrototype prototype) throws KernelException {
        SchemaDescriptor schema = prototype.schema();
        if (schema.entityType() == EntityType.RELATIONSHIP) {
            this.assertSupportedInVersion(KernelVersion.VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED, "Failed to create Relationship Uniqueness constraint.", new Object[0]);
        }
        this.exclusiveSchemaLock(schema);
        this.ktx.assertOpen();
        prototype = this.useLatestIndexProviderVersion(prototype);
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, (IndexType)prototype.getIndexType());
        try {
            this.assertValidDescriptor(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            if (prototype.getName().isEmpty()) {
                constraint = this.ensureConstraintHasName(constraint);
                prototype = prototype.withName(constraint.getName());
            } else {
                constraint = constraint.withName((String)prototype.getName().get());
            }
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists((ConstraintDescriptor)constraint);
        }
        catch (KernelException e) {
            this.exclusiveSchemaUnlock(schema);
            throw e;
        }
        constraint = this.indexBackedConstraintCreate(constraint, prototype, ignored -> {});
        return constraint;
    }

    private void assertNoBlockingSchemaRulesExists(IndexPrototype prototype) throws EquivalentSchemaRuleAlreadyExistsException, IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException, AlreadyIndexedException, AlreadyConstrainedException {
        Optional prototypeName = prototype.getName();
        if (prototypeName.isEmpty()) {
            throw new IllegalStateException("Expected index to always have a name by this point");
        }
        String name = (String)prototypeName.get();
        IndexDescriptor indexWithSameSchemaAndType = this.schemaRead.index(prototype.schema(), prototype.getIndexType());
        if (indexWithSameSchemaAndType.getName().equals(name) && indexWithSameSchemaAndType.isUnique() == prototype.isUnique()) {
            throw new EquivalentSchemaRuleAlreadyExistsException((SchemaRule)indexWithSameSchemaAndType, SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
        this.assertSchemaRuleWithNameDoesNotExist(name);
        Iterator<ConstraintDescriptor> constraintWithSameSchema = this.schemaRead.constraintsGetForSchema(prototype.schema());
        while (constraintWithSameSchema.hasNext()) {
            ConstraintDescriptor constraint = constraintWithSameSchema.next();
            if (!constraint.isIndexBackedConstraint() || constraint.asIndexBackedConstraint().indexType() != prototype.getIndexType()) continue;
            throw new AlreadyConstrainedException(constraint, SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
        if (indexWithSameSchemaAndType != IndexDescriptor.NO_INDEX) {
            throw new AlreadyIndexedException(prototype.schema(), SchemaKernelException.OperationContext.INDEX_CREATION, (TokenNameLookup)this.token);
        }
    }

    private void assertNoBlockingSchemaRulesExists(ConstraintDescriptor constraint) throws EquivalentSchemaRuleAlreadyExistsException, IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException, ConflictingConstraintException, AlreadyConstrainedException, AlreadyIndexedException, IncompatibleGraphTypeDependenceException {
        String name = constraint.getName();
        if (name == null) {
            throw new IllegalStateException("Expected constraint to always have a name by this point");
        }
        List constraintsWithSameSchema = Iterators.asList(this.schemaRead.constraintsGetForSchema(constraint.schema()));
        this.assertNoEquivalentConstraintExist(constraint, constraintsWithSameSchema);
        this.assertSchemaRuleWithNameDoesNotExist(name);
        this.assertNoConflictingConstraints(constraint, constraintsWithSameSchema);
        this.assertNotAlreadyIndexed(constraint);
        this.assertConstraintNotBackedBySimilarIndexDroppedInThisTx(constraint);
        this.assertNoConflictingGraphTypeDependence(constraint);
    }

    private void assertNoConflictingGraphTypeDependence(ConstraintDescriptor constraint) throws IncompatibleGraphTypeDependenceException {
        Iterator<ConstraintDescriptor> constraintsWithSameEntityToken;
        GraphTypeDependence thisDependence = constraint.graphTypeDependence();
        if (thisDependence == GraphTypeDependence.UNDESIGNATED) {
            return;
        }
        SchemaDescriptor schema = constraint.schema();
        switch (schema.entityType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NODE: {
                Iterator<ConstraintDescriptor> iterator = this.schemaRead.constraintsGetForLabel(schema.getLabelId());
                break;
            }
            case RELATIONSHIP: {
                Iterator<ConstraintDescriptor> iterator = constraintsWithSameEntityToken = this.schemaRead.constraintsGetForRelationshipType(schema.getRelTypeId());
            }
        }
        while (constraintsWithSameEntityToken.hasNext()) {
            ConstraintDescriptor constraintWithSameEntityToken = constraintsWithSameEntityToken.next();
            GraphTypeDependence thatDependence = constraintWithSameEntityToken.graphTypeDependence();
            if (thatDependence == GraphTypeDependence.UNDESIGNATED || thisDependence == thatDependence) continue;
            throw new IncompatibleGraphTypeDependenceException(constraint, constraintWithSameEntityToken, (TokenNameLookup)this.token);
        }
    }

    private void assertConstraintNotBackedBySimilarIndexDroppedInThisTx(ConstraintDescriptor constraint) {
        if (constraint.isIndexBackedConstraint() && this.ktx.hasTxStateWithChanges()) {
            for (ConstraintDescriptor droppedConstraint : this.ktx.txState().constraintsChanges().getRemoved()) {
                if (!droppedConstraint.isIndexBackedConstraint() || !constraint.schema().equals(droppedConstraint.schema()) || droppedConstraint.asIndexBackedConstraint().indexType() != constraint.asIndexBackedConstraint().indexType()) continue;
                throw new UnsupportedOperationException(String.format("Trying to create constraint '%s' in same transaction as dropping '%s'. This is not supported because they are both backed by similar indexes. Please drop constraint in a separate transaction before creating the new one.", constraint.getName(), droppedConstraint.getName()));
            }
        }
    }

    private void assertNotAlreadyIndexed(ConstraintDescriptor constraint) throws AlreadyIndexedException {
        IndexDescriptor existingIndex;
        if (constraint.isIndexBackedConstraint() && (existingIndex = this.schemaRead.index(constraint.schema(), constraint.asIndexBackedConstraint().indexType())) != IndexDescriptor.NO_INDEX) {
            throw new AlreadyIndexedException(existingIndex.schema(), SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
    }

    private void assertNoConflictingConstraints(ConstraintDescriptor constraint, List<ConstraintDescriptor> constraintsWithSameSchema) throws ConflictingConstraintException, AlreadyConstrainedException {
        for (ConstraintDescriptor constraintWithSameSchema : constraintsWithSameSchema) {
            boolean existingIndexBackedConstraint;
            if (constraint.isPropertyTypeConstraint() && constraintWithSameSchema.isPropertyTypeConstraint() && !constraint.equals(constraintWithSameSchema)) {
                throw ConflictingConstraintException.conflictingConstraint(constraintWithSameSchema, (TokenNameLookup)this.token);
            }
            boolean creatingIndexBackedConstraint = constraint.isIndexBackedConstraint();
            if (creatingIndexBackedConstraint != (existingIndexBackedConstraint = constraintWithSameSchema.isIndexBackedConstraint()) || (!creatingIndexBackedConstraint || constraintWithSameSchema.asIndexBackedConstraint().indexType() != constraint.asIndexBackedConstraint().indexType()) && (creatingIndexBackedConstraint || constraint.type() != constraintWithSameSchema.type())) continue;
            throw new AlreadyConstrainedException(constraintWithSameSchema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
    }

    private void assertNoEquivalentConstraintExist(ConstraintDescriptor constraint, List<ConstraintDescriptor> constraintsWithSameSchema) throws EquivalentSchemaRuleAlreadyExistsException {
        for (ConstraintDescriptor constraintWithSameSchema : constraintsWithSameSchema) {
            if (!constraint.equals(constraintWithSameSchema) || !constraint.getName().equals(constraintWithSameSchema.getName())) continue;
            throw new EquivalentSchemaRuleAlreadyExistsException((SchemaRule)constraintWithSameSchema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
        }
    }

    private void assertSchemaRuleWithNameDoesNotExist(String name) throws IndexWithNameAlreadyExistsException, ConstraintWithNameAlreadyExistsException {
        ConstraintDescriptor constraintWithSameName = this.schemaRead.constraintGetForName(name);
        if (constraintWithSameName != null) {
            throw ConstraintWithNameAlreadyExistsException.duplicatedConstraintName(name);
        }
        IndexDescriptor indexWithSameName = this.schemaRead.indexGetForName(name);
        if (indexWithSameName != IndexDescriptor.NO_INDEX) {
            throw IndexWithNameAlreadyExistsException.duplicateIndexName(name);
        }
    }

    private void assertSupportedInVersion(KernelVersion minimumVersionForSupport, String message, Object ... args) {
        StringBuilder unsupportedMessage = new StringBuilder().append(message.formatted(args));
        if (!this.checkSupportedInVerson(unsupportedMessage, minimumVersionForSupport)) {
            throw new UnsupportedOperationException(unsupportedMessage.toString());
        }
    }

    private boolean checkSupportedInVerson(StringBuilder sb, KernelVersion minimumVersionForSupport) {
        KernelVersion currentStoreVersion = this.kernelVersionProvider.kernelVersion();
        if (currentStoreVersion.isAtLeast(minimumVersionForSupport)) {
            return true;
        }
        KernelVersion currentDbmsVersion = this.dbmsRuntimeVersionProvider.getVersion().kernelVersion();
        if (currentDbmsVersion.isAtLeast(minimumVersionForSupport)) {
            return true;
        }
        if (!sb.isEmpty()) {
            sb.append(' ');
        }
        sb.append("Version was ").append(currentDbmsVersion.name()).append(", but required version for operation is ").append(minimumVersionForSupport.name()).append(". Please upgrade dbms using 'dbms.upgrade()'.");
        return false;
    }

    public ConstraintDescriptor keyConstraintCreate(IndexPrototype prototype) throws KernelException {
        SchemaDescriptor schema = prototype.schema();
        if (schema.entityType() == EntityType.RELATIONSHIP) {
            this.assertSupportedInVersion(KernelVersion.VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED, "Failed to create Relationship Key constraint.", new Object[0]);
        }
        this.exclusiveSchemaLock(schema);
        this.ktx.assertOpen();
        prototype = this.useLatestIndexProviderVersion(prototype);
        KeyConstraintDescriptor constraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema, (IndexType)prototype.getIndexType());
        try {
            this.assertValidDescriptor(schema, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            if (prototype.getName().isEmpty()) {
                constraint = this.ensureConstraintHasName(constraint);
                prototype = prototype.withName(constraint.getName());
            } else {
                constraint = constraint.withName((String)prototype.getName().get());
            }
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists((ConstraintDescriptor)constraint);
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock(schema);
            throw e;
        }
        this.constraintSemantics.assertKeyConstraintAllowed(constraint.schema());
        this.indexBackedConstraintCreate(constraint, prototype, this::enforceKeyConstraint);
        return constraint;
    }

    private void enforceKeyConstraint(SchemaDescriptor schema) throws KernelException {
        if (schema.entityType() == EntityType.NODE) {
            this.enforceNodeKeyConstraint(schema);
        } else {
            this.enforceRelKeyConstraint(schema);
        }
    }

    private void enforceNodeKeyConstraint(SchemaDescriptor schema) throws KernelException {
        IndexDescriptor index = this.findUsableTokenIndex(EntityType.NODE);
        if (index != IndexDescriptor.NO_INDEX) {
            try (DefaultNodeLabelIndexCursor cursor = this.cursors.allocateFullAccessNodeLabelIndexCursor(this.ktx.cursorContext());){
                TokenReadSession session = this.kernelRead.tokenReadSession(index);
                this.kernelRead.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getLabelId()), this.ktx.cursorContext());
                this.constraintSemantics.validateNodeKeyConstraint(cursor, this.nodeCursor, this.propertyCursor, (LabelSchemaDescriptor)schema.asSchemaDescriptorType(LabelSchemaDescriptor.class), (TokenNameLookup)this.token);
            }
        }
        try (FullAccessNodeCursor cursor = this.cursors.allocateFullAccessNodeCursor(this.ktx.cursorContext(), this.memoryTracker);){
            this.kernelRead.allNodesScan(cursor);
            this.constraintSemantics.validateNodeKeyConstraint(new FilteringNodeCursorWrapper(cursor, CursorPredicates.hasLabel(schema.getLabelId())), this.propertyCursor, (LabelSchemaDescriptor)schema.asSchemaDescriptorType(LabelSchemaDescriptor.class), (TokenNameLookup)this.token);
        }
    }

    private void enforceRelKeyConstraint(SchemaDescriptor schema) throws KernelException {
        IndexDescriptor index = this.findUsableTokenIndex(EntityType.RELATIONSHIP);
        if (index != IndexDescriptor.NO_INDEX) {
            try (RelationshipTypeIndexCursor cursor = this.cursors.allocateFullAccessRelationshipTypeIndexCursor(this.ktx.cursorContext(), this.memoryTracker);){
                TokenReadSession session = this.kernelRead.tokenReadSession(index);
                this.kernelRead.relationshipTypeScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getRelTypeId()), this.ktx.cursorContext());
                this.constraintSemantics.validateRelKeyConstraint(cursor, this.relationshipCursor, this.propertyCursor, (RelationTypeSchemaDescriptor)schema.asSchemaDescriptorType(RelationTypeSchemaDescriptor.class), (TokenNameLookup)this.token);
            }
        }
        try (DefaultRelationshipScanCursor cursor = this.cursors.allocateFullAccessRelationshipScanCursor(this.ktx.cursorContext(), this.memoryTracker);){
            this.kernelRead.allRelationshipsScan(cursor);
            this.constraintSemantics.validateRelKeyConstraint(new FilteringRelationshipScanCursorWrapper(cursor, CursorPredicates.hasType(schema.getRelTypeId())), this.propertyCursor, (RelationTypeSchemaDescriptor)schema.asSchemaDescriptorType(RelationTypeSchemaDescriptor.class), (TokenNameLookup)this.token);
        }
    }

    public ConstraintDescriptor nodePropertyExistenceConstraintCreate(LabelSchemaDescriptor schema, String name, boolean isDependent) throws KernelException {
        ConstraintDescriptor constraint = this.lockAndValidatePropertyExistenceConstraint((SchemaDescriptor)schema, name, isDependent);
        this.enforceNodePropertyExistenceConstraint(schema, isDependent);
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    private void enforceNodePropertyConstraint(LabelSchemaDescriptor schema, NodeValidatorWithIndex nodeValidatorWithIndex, NodeValidatorWithoutIndex nodeValidatorWithoutIndex) throws KernelException {
        IndexDescriptor index = this.findUsableTokenIndex(EntityType.NODE);
        if (index != IndexDescriptor.NO_INDEX) {
            try (DefaultNodeLabelIndexCursor cursor = this.cursors.allocateFullAccessNodeLabelIndexCursor(this.ktx.cursorContext());){
                TokenReadSession session = this.kernelRead.tokenReadSession(index);
                this.kernelRead.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getLabelId()), this.ktx.cursorContext());
                nodeValidatorWithIndex.validate(cursor, this.nodeCursor, this.propertyCursor, (TokenNameLookup)this.token);
            }
        }
        try (FullAccessNodeCursor cursor = this.cursors.allocateFullAccessNodeCursor(this.ktx.cursorContext(), this.memoryTracker);){
            this.kernelRead.allNodesScan(cursor);
            nodeValidatorWithoutIndex.validate(new FilteringNodeCursorWrapper(cursor, CursorPredicates.hasLabel(schema.getLabelId())), this.propertyCursor, (TokenNameLookup)this.token);
        }
    }

    private void enforceNodePropertyExistenceConstraint(LabelSchemaDescriptor schema, boolean isDependent) throws KernelException {
        this.enforceNodePropertyConstraint(schema, (allNodes, nodeCursor, propertyCursor, tokenNameLookup) -> this.constraintSemantics.validateNodePropertyExistenceConstraint(allNodes, nodeCursor, propertyCursor, schema, tokenNameLookup, isDependent), (nodeCursor, propertyCursor, tokenNameLookup) -> this.constraintSemantics.validateNodePropertyExistenceConstraint(nodeCursor, propertyCursor, schema, tokenNameLookup, isDependent));
    }

    private void enforceNodePropertyTypeConstraint(TypeConstraintDescriptor descriptor) throws KernelException {
        this.enforceNodePropertyConstraint((LabelSchemaDescriptor)descriptor.schema().asSchemaDescriptorType(LabelSchemaDescriptor.class), (allNodes, nodeCursor, propertyCursor, tokenNameLookup) -> this.constraintSemantics.validateNodePropertyTypeConstraint(allNodes, nodeCursor, propertyCursor, descriptor, tokenNameLookup), (nodeCursor, propertyCursor, tokenNameLookup) -> this.constraintSemantics.validateNodePropertyTypeConstraint(nodeCursor, propertyCursor, descriptor, tokenNameLookup));
    }

    public ConstraintDescriptor relationshipPropertyExistenceConstraintCreate(RelationTypeSchemaDescriptor schema, String name, boolean isDependent) throws KernelException {
        ConstraintDescriptor constraint = this.lockAndValidatePropertyExistenceConstraint((SchemaDescriptor)schema, name, isDependent);
        this.enforceRelationshipPropertyExistenceConstraint(schema, isDependent);
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    private void enforceRelationshipPropertyConstraint(RelationTypeSchemaDescriptor schema, RelValidatorWithIndex relValidatorWithIndex, RelValidatorWithoutIndex relValidatorWithoutIndex) throws KernelException {
        IndexDescriptor index = this.findUsableTokenIndex(EntityType.RELATIONSHIP);
        if (index != IndexDescriptor.NO_INDEX) {
            try (RelationshipTypeIndexCursor fullAccessIndexCursor = this.cursors.allocateFullAccessRelationshipTypeIndexCursor(this.ktx.cursorContext(), this.memoryTracker);){
                TokenReadSession session = this.kernelRead.tokenReadSession(index);
                this.kernelRead.relationshipTypeScan(session, fullAccessIndexCursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getRelTypeId()), this.ktx.cursorContext());
                relValidatorWithIndex.validate(fullAccessIndexCursor, this.propertyCursor, (TokenNameLookup)this.token);
            }
        }
        try (DefaultRelationshipScanCursor fullAccessCursor = this.cursors.allocateFullAccessRelationshipScanCursor(this.ktx.cursorContext(), this.memoryTracker);){
            this.kernelRead.allRelationshipsScan(fullAccessCursor);
            relValidatorWithoutIndex.validate(new FilteringRelationshipScanCursorWrapper(fullAccessCursor, CursorPredicates.hasType(schema.getRelTypeId())), this.propertyCursor, (TokenNameLookup)this.token);
        }
    }

    private void enforceRelationshipPropertyExistenceConstraint(RelationTypeSchemaDescriptor schema, boolean isDependent) throws KernelException {
        this.enforceRelationshipPropertyConstraint(schema, (relationships, propertyCursor, tokenNameLookup) -> this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(relationships, propertyCursor, schema, tokenNameLookup, isDependent), (relationships, propertyCursor, tokenNameLookup) -> this.constraintSemantics.validateRelationshipPropertyExistenceConstraint(relationships, propertyCursor, schema, tokenNameLookup, isDependent));
    }

    private void enforceRelationshipPropertyTypeConstraint(TypeConstraintDescriptor descriptor) throws KernelException {
        this.enforceRelationshipPropertyConstraint((RelationTypeSchemaDescriptor)descriptor.schema().asSchemaDescriptorType(RelationTypeSchemaDescriptor.class), (relationships, propertyCursor, tokenNameLookup) -> this.constraintSemantics.validateRelationshipPropertyTypeConstraint(relationships, propertyCursor, descriptor, tokenNameLookup), (relationships, propertyCursor, tokenNameLookup) -> this.constraintSemantics.validateRelationshipPropertyTypeConstraint(relationships, propertyCursor, descriptor, tokenNameLookup));
    }

    public ConstraintDescriptor propertyTypeConstraintCreate(SchemaDescriptor schema, String name, PropertyTypeSet propertyType, boolean isDependent) throws KernelException {
        if (schema.getPropertyIds().length != 1) {
            throw new UnsupportedOperationException("Composite property type constraints are not supported.");
        }
        this.assertSupportedInVersion(KernelVersion.VERSION_TYPE_CONSTRAINTS_INTRODUCED, "Failed to create property type constraint.", new Object[0]);
        ConstraintDescriptor constraint = this.lockAndValidatePropertyTypeConstraint(schema, name, propertyType, isDependent);
        TypeConstraintDescriptor descriptor = constraint.asPropertyTypeConstraint();
        if (descriptor.schema().isSchemaDescriptorType(RelationTypeSchemaDescriptor.class)) {
            this.enforceRelationshipPropertyTypeConstraint(descriptor);
        } else {
            this.enforceNodePropertyTypeConstraint(descriptor);
        }
        this.ktx.txState().constraintDoAdd(constraint);
        return constraint;
    }

    public ConstraintDescriptor relationshipEndpointLabelConstraintCreate(RelationshipEndpointLabelSchemaDescriptor schema, String name, int endpointLabelId, EndpointType endpointType) throws KernelException {
        if (!this.relationshipEndpointLabelAndNodeLabelExistenceConstraintsEnabled) {
            throw new UnsupportedOperationException("Relationship endpoint constraints are not enabled, setting: " + GraphDatabaseInternalSettings.relationship_endpoint_label_and_node_label_existence_constraints.name());
        }
        RelationshipEndpointLabelConstraintDescriptor constraint = this.lockAndValidateRelationshipEndpointLabelConstraint(schema, name, endpointLabelId, endpointType);
        this.enforceRelationshipEndpointLabelConstraint(constraint);
        this.ktx.txState().constraintDoAdd((ConstraintDescriptor)constraint);
        return constraint;
    }

    private void enforceRelationshipEndpointLabelConstraint(RelationshipEndpointLabelConstraintDescriptor descriptor) throws KernelException {
        block25: {
            this.exclusiveLock(ResourceType.LABEL, new long[]{descriptor.endpointLabelId()});
            IndexDescriptor index = this.findUsableTokenIndex(EntityType.RELATIONSHIP);
            if (index != IndexDescriptor.NO_INDEX) {
                try (RelationshipTypeIndexCursor fullAccessRelationshipIndexCursor = this.cursors.allocateFullAccessRelationshipTypeIndexCursor(this.ktx.cursorContext(), this.memoryTracker);
                     FullAccessNodeCursor nodeCursor = this.cursors.allocateFullAccessNodeCursor(this.ktx.cursorContext(), this.memoryTracker);){
                    TokenReadSession session = this.kernelRead.tokenReadSession(index);
                    this.kernelRead.relationshipTypeScan(session, fullAccessRelationshipIndexCursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(descriptor.schema().getRelTypeId()), this.ktx.cursorContext());
                    this.constraintSemantics.validateRelationshipEndpointLabelConstraint(fullAccessRelationshipIndexCursor, nodeCursor, descriptor, (TokenNameLookup)this.token);
                    break block25;
                }
            }
            try (DefaultRelationshipScanCursor allRelationshipsCursor = this.cursors.allocateFullAccessRelationshipScanCursor(this.ktx.cursorContext(), this.memoryTracker);
                 FullAccessNodeCursor nodeCursor = this.cursors.allocateFullAccessNodeCursor(this.ktx.cursorContext(), this.memoryTracker);){
                this.kernelRead.allRelationshipsScan(allRelationshipsCursor);
                this.constraintSemantics.validateRelationshipEndpointLabelConstraint(new FilteringRelationshipScanCursorWrapper(allRelationshipsCursor, CursorPredicates.hasType(descriptor.schema().getRelTypeId())), nodeCursor, descriptor, (TokenNameLookup)this.token);
            }
        }
    }

    private RelationshipEndpointLabelConstraintDescriptor lockAndValidateRelationshipEndpointLabelConstraint(RelationshipEndpointLabelSchemaDescriptor schemaDescriptor, String name, int endpointLabelId, EndpointType endpointType) throws KernelException {
        this.exclusiveSchemaLock((SchemaDescriptor)schemaDescriptor);
        this.ktx.assertOpen();
        try {
            this.assertValidDescriptor((SchemaDescriptor)schemaDescriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock((SchemaDescriptor)schemaDescriptor);
            throw new RuntimeException(e);
        }
        RelationshipEndpointLabelConstraintDescriptor constraint = ConstraintDescriptorFactory.relationshipEndpointLabelForSchema((RelationshipEndpointLabelSchemaDescriptor)schemaDescriptor, (int)endpointLabelId, (EndpointType)endpointType).withName(name);
        constraint = this.ensureConstraintHasName(constraint);
        this.exclusiveSchemaNameLock(constraint.getName());
        try {
            this.assertNoBlockingSchemaRulesExists((ConstraintDescriptor)constraint);
            return constraint;
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock((SchemaDescriptor)schemaDescriptor);
            throw e;
        }
    }

    public ConstraintDescriptor nodeLabelExistenceConstraintCreate(NodeLabelExistenceSchemaDescriptor schema, String name, int requiredLabelId) throws KernelException {
        if (!this.relationshipEndpointLabelAndNodeLabelExistenceConstraintsEnabled) {
            throw new UnsupportedOperationException("Node label existence constraints are not enabled, setting: " + GraphDatabaseInternalSettings.relationship_endpoint_label_and_node_label_existence_constraints.name());
        }
        NodeLabelExistenceConstraintDescriptor constraint = this.lockAndValidateNodeLabelExistenceConstraint(schema, name, requiredLabelId);
        this.enforceNodeLabelExistenceConstraint(constraint);
        this.ktx.txState().constraintDoAdd((ConstraintDescriptor)constraint);
        return constraint;
    }

    private NodeLabelExistenceConstraintDescriptor lockAndValidateNodeLabelExistenceConstraint(NodeLabelExistenceSchemaDescriptor schemaDescriptor, String name, int requiredLabelId) throws KernelException {
        this.exclusiveSchemaLock((SchemaDescriptor)schemaDescriptor);
        this.ktx.assertOpen();
        try {
            this.assertValidDescriptor((SchemaDescriptor)schemaDescriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock((SchemaDescriptor)schemaDescriptor);
            throw new RuntimeException(e);
        }
        NodeLabelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeLabelExistenceForSchema((NodeLabelExistenceSchemaDescriptor)schemaDescriptor, (int)requiredLabelId).withName(name).asNodeLabelExistenceConstraint();
        constraint = this.ensureConstraintHasName(constraint);
        this.exclusiveSchemaNameLock(constraint.getName());
        try {
            this.assertNoBlockingSchemaRulesExists((ConstraintDescriptor)constraint);
            return constraint;
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock((SchemaDescriptor)schemaDescriptor);
            throw e;
        }
    }

    private void enforceNodeLabelExistenceConstraint(NodeLabelExistenceConstraintDescriptor descriptor) throws KernelException {
        this.exclusiveLock(ResourceType.LABEL, new long[]{descriptor.requiredLabelId()});
        SchemaDescriptor schema = descriptor.schema();
        IndexDescriptor index = this.findUsableTokenIndex(EntityType.NODE);
        if (index != IndexDescriptor.NO_INDEX) {
            try (DefaultNodeLabelIndexCursor cursor = this.cursors.allocateFullAccessNodeLabelIndexCursor(this.ktx.cursorContext());){
                TokenReadSession session = this.kernelRead.tokenReadSession(index);
                this.kernelRead.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(schema.getLabelId()), this.ktx.cursorContext());
                this.constraintSemantics.validateNodeLabelExistenceConstraint(cursor, this.nodeCursor, descriptor, (TokenNameLookup)this.token);
            }
        }
        try (FullAccessNodeCursor cursor = this.cursors.allocateFullAccessNodeCursor(this.ktx.cursorContext(), this.ktx.memoryTracker());){
            this.kernelRead.allNodesScan(cursor);
            this.constraintSemantics.validateNodeLabelExistenceConstraint(new FilteringNodeCursorWrapper(cursor, CursorPredicates.hasLabel(schema.getLabelId())), descriptor, (TokenNameLookup)this.token);
        }
    }

    private ConstraintDescriptor lockAndValidatePropertyExistenceConstraint(SchemaDescriptor descriptor, String name, boolean isDependent) throws KernelException {
        return this.lockAndValidateNonIndexPropertyConstraint(descriptor, schema -> ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)schema, (boolean)isDependent), name);
    }

    private ConstraintDescriptor lockAndValidatePropertyTypeConstraint(SchemaDescriptor descriptor, String name, PropertyTypeSet propertyType, boolean isDependent) throws KernelException {
        TypeRepresentation.validate((PropertyTypeSet)propertyType);
        boolean isUnion = TypeRepresentation.isUnion((PropertyTypeSet)propertyType);
        boolean hasListType = TypeRepresentation.hasListTypes((PropertyTypeSet)propertyType);
        if (isUnion || hasListType) {
            this.assertSupportedInVersion(KernelVersion.VERSION_UNIONS_AND_LIST_TYPE_CONSTRAINTS_INTRODUCED, "Failed to create property type constraint with %s.", propertyType.userDescription());
        }
        return this.lockAndValidateNonIndexPropertyConstraint(descriptor, desc -> ConstraintDescriptorFactory.typeForSchema((SchemaDescriptor)desc, (PropertyTypeSet)propertyType, (boolean)isDependent), name);
    }

    private ConstraintDescriptor lockAndValidateNonIndexPropertyConstraint(SchemaDescriptor descriptor, Function<SchemaDescriptor, ConstraintDescriptor> constraintFunction, String name) throws KernelException {
        this.exclusiveSchemaLock(descriptor);
        this.ktx.assertOpen();
        try {
            this.assertValidDescriptor(descriptor, SchemaKernelException.OperationContext.CONSTRAINT_CREATION);
            ConstraintDescriptor constraint = constraintFunction.apply(descriptor).withName(name);
            if (!this.dependentConstraintsEnabled && constraint.graphTypeDependence() == GraphTypeDependence.DEPENDENT) {
                throw new UnsupportedOperationException("Graph dependent constraints are not enabled, setting: " + GraphDatabaseInternalSettings.dependent_constraints_enabled.name());
            }
            constraint = this.ensureConstraintHasName(constraint);
            this.exclusiveSchemaNameLock(constraint.getName());
            this.assertNoBlockingSchemaRulesExists(constraint);
            return constraint;
        }
        catch (SchemaKernelException e) {
            this.exclusiveSchemaUnlock(descriptor);
            throw e;
        }
    }

    public void constraintDrop(String name, boolean canDropDependent) throws SchemaKernelException {
        this.exclusiveSchemaNameLock(name);
        ConstraintDescriptor constraint = this.schemaRead.constraintGetForName(name);
        if (constraint == null) {
            throw DropConstraintFailureException.constraintDropFailed(name, (Throwable)((Object)new NoSuchConstraintException(name)));
        }
        this.constraintDrop(constraint, canDropDependent);
    }

    public void constraintDrop(ConstraintDescriptor constraint, boolean canDropDependent) throws SchemaKernelException {
        IndexDescriptor index;
        SchemaDescriptor schema = constraint.schema();
        this.exclusiveLock(schema.keyType(), schema.lockingKeys());
        this.exclusiveSchemaNameLock(constraint.getName());
        this.ktx.assertOpen();
        if (constraint.graphTypeDependence() == GraphTypeDependence.DEPENDENT && !canDropDependent) {
            throw DropConstraintFailureException.constraintDropFailed(constraint, (Throwable)new IllegalStateException("Cannot drop dependent constraint"));
        }
        try {
            this.assertConstraintExists(constraint);
        }
        catch (NoSuchConstraintException e) {
            throw DropConstraintFailureException.constraintDropFailed(constraint, (Throwable)((Object)e));
        }
        TransactionState txState = this.ktx.txState();
        txState.constraintDoDrop(constraint);
        if (constraint.enforcesUniqueness() && (index = this.schemaRead.indexGetForName(constraint.getName())) != IndexDescriptor.NO_INDEX) {
            txState.indexDoDrop(index);
        }
    }

    private void exclusiveLock(ResourceType resource, long[] resourceIds) {
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), resource, resourceIds);
    }

    private void acquireExclusiveNodeLock(long node) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().nodeIsAddedInThisBatch(node)) {
            this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), ResourceType.NODE, new long[]{node});
        }
    }

    private void acquireExclusiveRelationshipLock(long relationshipId) {
        if (!this.ktx.hasTxStateWithChanges() || !this.ktx.txState().relationshipIsAddedInThisBatch(relationshipId)) {
            this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), ResourceType.RELATIONSHIP, new long[]{relationshipId});
        }
    }

    private void sharedSchemaLock(ResourceType type, long tokenId) {
        this.ktx.lockClient().acquireShared(this.ktx.lockTracer(), type, new long[]{tokenId});
    }

    private void sharedTokenSchemaLock(ResourceType rt) {
        this.sharedSchemaLock(rt, Integer.MAX_VALUE);
    }

    private void exclusiveSchemaLock(SchemaDescriptor schema) {
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), schema.keyType(), schema.lockingKeys());
    }

    private void exclusiveSchemaUnlock(SchemaDescriptor schema) {
        this.ktx.lockClient().releaseExclusive(schema.keyType(), schema.lockingKeys());
    }

    private void exclusiveSchemaNameLock(String schemaName) {
        long lockingId = ResourceIds.schemaNameResourceId(schemaName);
        this.ktx.lockClient().acquireExclusive(this.ktx.lockTracer(), ResourceType.SCHEMA_NAME, new long[]{lockingId});
    }

    private static boolean propertyHasChanged(Value lhs, Value rhs) {
        return !lhs.isSameValueTypeAs(rhs) || !lhs.equals(rhs);
    }

    private void assertNodeExists(long nodeId) throws EntityNotFoundException {
        if (!this.kernelRead.nodeExists(nodeId)) {
            throw new EntityNotFoundException(EntityType.NODE, this.ktx.internalTransaction().elementIdMapper().nodeElementId(nodeId));
        }
    }

    private void assertNodeDoesntExist(long nodeId) throws EntityAlreadyExistsException {
        if (this.kernelRead.nodeExists(nodeId)) {
            throw new EntityAlreadyExistsException(EntityType.NODE, this.ktx.internalTransaction().elementIdMapper().nodeElementId(nodeId));
        }
    }

    private void assertRelationshipDoesntExist(long relationshipId) throws EntityAlreadyExistsException {
        if (this.kernelRead.relationshipExists(relationshipId)) {
            throw new EntityAlreadyExistsException(EntityType.RELATIONSHIP, this.ktx.internalTransaction().elementIdMapper().relationshipElementId(relationshipId));
        }
    }

    private void assertConstraintExists(ConstraintDescriptor constraint) throws NoSuchConstraintException {
        if (!this.schemaRead.constraintExists(constraint)) {
            throw new NoSuchConstraintException((SchemaDescriptorSupplier)constraint, (TokenNameLookup)this.token);
        }
    }

    private void assertValidDescriptor(SchemaDescriptor descriptor, SchemaKernelException.OperationContext context) throws RepeatedSchemaComponentException {
        long numUniqueProp = Arrays.stream(descriptor.getPropertyIds()).distinct().count();
        long numUniqueEntityTokens = Arrays.stream(descriptor.getEntityTokenIds()).distinct().count();
        if (numUniqueProp != (long)descriptor.getPropertyIds().length) {
            throw new RepeatedPropertyInSchemaException(descriptor, context, (TokenNameLookup)this.token);
        }
        if (numUniqueEntityTokens != (long)descriptor.getEntityTokenIds().length) {
            if (descriptor.entityType() == EntityType.NODE) {
                throw new RepeatedLabelInSchemaException(descriptor, context, (TokenNameLookup)this.token);
            }
            throw new RepeatedRelationshipTypeInSchemaException(descriptor, context, (TokenNameLookup)this.token);
        }
    }

    private <T extends IndexBackedConstraintDescriptor> T indexBackedConstraintCreate(T constraint, IndexPrototype prototype, ConstraintIndexCreator.PropertyExistenceEnforcer propertyExistenceEnforcer) throws KernelException {
        try {
            if (this.schemaRead.constraintExists((ConstraintDescriptor)constraint)) {
                throw new AlreadyConstrainedException((ConstraintDescriptor)constraint, SchemaKernelException.OperationContext.CONSTRAINT_CREATION, (TokenNameLookup)this.token);
            }
            IndexType indexType = prototype.getIndexType();
            if (indexType != IndexType.RANGE) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index with index type " + indexType + ".");
            }
            if (prototype.schema().isSchemaDescriptorType(FulltextSchemaDescriptor.class)) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index using a full-text schema: " + prototype.schema().userDescription((TokenNameLookup)this.token));
            }
            if (prototype.schema().isSchemaDescriptorType(AnyTokenSchemaDescriptor.class)) {
                throw new CreateConstraintFailureException(constraint, "Cannot create backing constraint index using an any token schema: " + prototype.schema().userDescription((TokenNameLookup)this.token));
            }
            if (!prototype.isUnique()) {
                throw new CreateConstraintFailureException(constraint, "Cannot create index backed constraint using an index prototype that is not unique: " + prototype.userDescription((TokenNameLookup)this.token));
            }
            IndexDescriptor index = this.constraintIndexCreator.createUniquenessConstraintIndex(this.ktx, (IndexBackedConstraintDescriptor)constraint, prototype, propertyExistenceEnforcer);
            if (!this.schemaRead.constraintExists((ConstraintDescriptor)constraint)) {
                constraint = constraint.withOwnedIndexId(index.getId());
                this.ktx.txState().constraintDoAdd(constraint, index);
            } else {
                Iterator<ConstraintDescriptor> constraintsWithSchema = this.schemaRead.constraintsGetForSchema(constraint.schema());
                while (constraintsWithSchema.hasNext()) {
                    ConstraintDescriptor next = constraintsWithSchema.next();
                    if (!next.isIndexBackedConstraint() || next.asIndexBackedConstraint().indexType() != constraint.indexType()) continue;
                    constraint = (IndexBackedConstraintDescriptor)constraintsWithSchema;
                    break;
                }
            }
            return constraint;
        }
        catch (TransactionFailureException | AlreadyConstrainedException | UniquePropertyValueValidationException e) {
            throw CreateConstraintFailureException.constraintCreationFailed(constraint, (String)constraint.userDescription((TokenNameLookup)this.token), (ErrorGqlStatusObject)e.gqlStatusObject(), (Throwable)e);
        }
    }

    private <T extends ConstraintDescriptor> T ensureConstraintHasName(T constraint) throws KernelException {
        return (T)(constraint.getName() == null ? constraint.withName(this.generateNameFrom((SchemaDescriptorSupplier)constraint)) : constraint);
    }

    private String generateNameFrom(SchemaDescriptorSupplier schemaDescriptorSupplier) {
        return SchemaNameUtil.generateName((SchemaDescriptorSupplier)schemaDescriptorSupplier, (TokenNameLookup)this.token);
    }

    IndexDescriptor findUsableTokenIndex(EntityType entityType) throws IndexNotFoundKernelException {
        AnyTokenSchemaDescriptor descriptor = SchemaDescriptors.forAnyEntityTokens((EntityType)entityType);
        IndexDescriptor index = this.schemaRead.index((SchemaDescriptor)descriptor, IndexType.LOOKUP);
        if (index != IndexDescriptor.NO_INDEX && this.schemaRead.indexGetState(index) == InternalIndexState.ONLINE) {
            return index;
        }
        return IndexDescriptor.NO_INDEX;
    }

    public void upgradeKernel(Upgrade.KernelUpgrade kernelUpgrade) {
        this.ktx.txState().kernelDoUpgrade(kernelUpgrade);
    }

    @FunctionalInterface
    private static interface NodeValidatorWithIndex {
        public void validate(NodeLabelIndexCursor var1, NodeCursor var2, PropertyCursor var3, TokenNameLookup var4) throws CreateConstraintFailureException;
    }

    @FunctionalInterface
    private static interface NodeValidatorWithoutIndex {
        public void validate(NodeCursor var1, PropertyCursor var2, TokenNameLookup var3) throws CreateConstraintFailureException;
    }

    @FunctionalInterface
    private static interface RelValidatorWithIndex {
        public void validate(RelationshipTypeIndexCursor var1, PropertyCursor var2, TokenNameLookup var3) throws CreateConstraintFailureException;
    }

    @FunctionalInterface
    private static interface RelValidatorWithoutIndex {
        public void validate(RelationshipScanCursor var1, PropertyCursor var2, TokenNameLookup var3) throws CreateConstraintFailureException;
    }
}

