/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultEntityTokenIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;

class DefaultNodeLabelIndexCursor
extends DefaultEntityTokenIndexCursor<DefaultNodeLabelIndexCursor>
implements NodeLabelIndexCursor {
    private final InternalCursorFactory internalCursors;
    private final boolean applyAccessModeToTxState;
    private DefaultNodeCursor securityNodeCursor;

    DefaultNodeLabelIndexCursor(CursorPool<DefaultNodeLabelIndexCursor> pool, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super(pool, applyAccessModeToTxState);
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    @Override
    protected boolean innerNext() {
        return this.indexNext();
    }

    @Override
    protected LongIterator createAddedInTxState(TransactionState txState, int token, IndexOrder order) {
        return DefaultNodeLabelIndexCursor.sortTxState(txState.nodesWithLabelChanged(token).getAdded().freeze(), order);
    }

    @Override
    protected LongSet createDeletedInTxState(TransactionState txState, int token) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)txState.nodesWithLabelChanged(token).getRemoved()).asUnmodifiable();
    }

    @Override
    protected void traceScan(KernelReadTracer tracer, int token) {
        tracer.onLabelScan(token);
    }

    @Override
    protected void traceNext(KernelReadTracer tracer, long entity) {
        tracer.onNode(entity);
    }

    @Override
    protected boolean allowedToSeeAllEntitiesWithToken(int token) {
        return this.accessModeProvider.getAccessMode().allowsTraverseAllNodesWithLabel(token);
    }

    @Override
    protected boolean allowedToSeeEntity(long entityReference) {
        if (this.accessModeProvider.getAccessMode().allowsTraverseAllLabels()) {
            return true;
        }
        if (this.securityNodeCursor == null) {
            this.securityNodeCursor = this.internalCursors.allocateNodeCursor();
        }
        this.read.singleNode(entityReference, (NodeCursor)this.securityNodeCursor);
        return this.securityNodeCursor.next();
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.entityReference(), cursor);
    }

    public long nodeReference() {
        return this.entityReference();
    }

    public float score() {
        return Float.NaN;
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeLabelIndexCursor[closed state]";
        }
        return "NodeLabelIndexCursor[node=" + this.entityReference() + ", label= " + this.tokenId + "]";
    }

    @Override
    public void release() {
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
            this.securityNodeCursor = null;
        }
    }
}

