/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Map;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.kernel.impl.coreapi.schema.BaseRelationshipConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class RelationshipPropertyTypeConstraintCreator
extends BaseRelationshipConstraintCreator {
    private final String propertyKey;
    private final PropertyTypeSet allowedTypes;

    RelationshipPropertyTypeConstraintCreator(InternalSchemaActions actions, String name, RelationshipType type, String propertyKey, IndexType indexType, IndexConfig indexConfig, PropertyTypeSet allowedTypes) {
        super(actions, name, type, indexType, indexConfig);
        this.propertyKey = propertyKey;
        this.allowedTypes = allowedTypes;
    }

    @Override
    public ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        throw new UnsupportedOperationException("You cannot create a property type constraint together with other constraints.");
    }

    @Override
    public ConstraintCreator assertPropertyExists(String propertyKey) {
        throw new UnsupportedOperationException("You cannot create a property type constraint together with other constraints.");
    }

    @Override
    public ConstraintCreator assertPropertyIsRelationshipKey(String propertyKey) {
        throw new UnsupportedOperationException("You cannot create a property type constraint together with other constraints.");
    }

    @Override
    public ConstraintCreator assertPropertyHasType(String propertyKey, PropertyType ... propertyType) {
        throw new UnsupportedOperationException("You can only create one property type constraint at a time.");
    }

    @Override
    public ConstraintDefinition create() {
        if (this.indexType != null) {
            throw new IllegalArgumentException("Relationship property type constraints cannot be created with an index type. Was given index type " + this.indexType + ".");
        }
        if (this.indexConfig != null) {
            throw new IllegalArgumentException("Relationship property type constraints cannot be created with an index configuration.");
        }
        return this.actions.createPropertyTypeConstraint(this.name, this.type, this.propertyKey, this.allowedTypes);
    }

    @Override
    public ConstraintCreator withName(String name) {
        return new RelationshipPropertyTypeConstraintCreator(this.actions, name, this.type, this.propertyKey, this.indexType, this.indexConfig, this.allowedTypes);
    }

    @Override
    public ConstraintCreator withIndexType(IndexType indexType) {
        return new RelationshipPropertyTypeConstraintCreator(this.actions, this.name, this.type, this.propertyKey, indexType, this.indexConfig, this.allowedTypes);
    }

    @Override
    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new RelationshipPropertyTypeConstraintCreator(this.actions, this.name, this.type, this.propertyKey, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration), this.allowedTypes);
    }
}

