/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.api.state.ValuesContainer;
import org.neo4j.kernel.impl.util.collection.Memory;
import org.neo4j.kernel.impl.util.collection.MemoryAllocator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueByteBufferCodec;

public class AppendOnlyValuesContainer
implements ValuesContainer {
    private static final int CHUNK_SIZE = (int)ByteUnit.kibiBytes((long)512L);
    private static final int REMOVED = 255;
    private final int chunkSize;
    private final List<ByteBuffer> chunks = new ArrayList<ByteBuffer>();
    private final List<Memory> allocated = new ArrayList<Memory>();
    private final ValueByteBufferCodec.Writer writer;
    private final MemoryAllocator allocator;
    private final MemoryTracker memoryTracker;
    private ByteBuffer currentChunk;
    private boolean closed;

    public AppendOnlyValuesContainer(MemoryAllocator allocator, MemoryTracker memoryTracker) {
        this(CHUNK_SIZE, allocator, memoryTracker);
    }

    @VisibleForTesting
    AppendOnlyValuesContainer(int chunkSize, MemoryAllocator allocator, MemoryTracker memoryTracker) {
        this.chunkSize = chunkSize;
        this.allocator = allocator;
        this.memoryTracker = memoryTracker;
        this.writer = new ValueByteBufferCodec.Writer(chunkSize, (ValueByteBufferCodec.ByteBufferAllocator)new OffHeapByteBufferAllocator(allocator, memoryTracker));
    }

    @Override
    public long add(Value value) {
        this.assertNotClosed();
        Objects.requireNonNull(value, "value cannot be null");
        ByteBuffer buf = this.writer.write(value);
        if (this.currentChunk == null || buf.remaining() > this.currentChunk.remaining()) {
            this.currentChunk = this.addNewChunk(Math.max(this.chunkSize, buf.remaining()));
        }
        long ref = (long)this.chunks.size() - 1L << 32 | (long)this.currentChunk.position();
        this.currentChunk.put(buf);
        return ref;
    }

    @Override
    public Value get(long ref) {
        this.assertNotClosed();
        int chunkIdx = (int)(ref >>> 32);
        int offset = (int)ref;
        Preconditions.checkArgument((chunkIdx >= 0 && chunkIdx < this.chunks.size() ? 1 : 0) != 0, (String)"invalid chunk idx %d (total #%d chunks), ref: 0x%X", (Object[])new Object[]{chunkIdx, this.chunks.size(), ref});
        ByteBuffer chunk = this.chunks.get(chunkIdx);
        Preconditions.checkArgument((offset >= 0 && offset < chunk.position() ? 1 : 0) != 0, (String)"invalid chunk offset (%d), ref: 0x%X", (Object[])new Object[]{offset, ref});
        int typeId = chunk.get(offset) & 0xFF;
        Preconditions.checkArgument((typeId != 255 ? 1 : 0) != 0, (String)"element is already removed, ref: 0x%X", (Object[])new Object[]{ref});
        Preconditions.checkArgument((typeId < ValueByteBufferCodec.VALUE_TYPES.length ? 1 : 0) != 0, (String)"invaling typeId (%d) for ref 0x%X", (Object[])new Object[]{typeId, ref});
        ValueByteBufferCodec.ValueType type = ValueByteBufferCodec.VALUE_TYPES[typeId];
        return type.getReader().read(chunk, ++offset);
    }

    @Override
    public Value remove(long ref) {
        this.assertNotClosed();
        Value removed = this.get(ref);
        int chunkIdx = (int)(ref >>> 32);
        int chunkOffset = (int)ref;
        ByteBuffer chunk = this.chunks.get(chunkIdx);
        chunk.put(chunkOffset, (byte)-1);
        return removed;
    }

    public void close() {
        this.assertNotClosed();
        this.closed = true;
        this.allocated.forEach(m -> m.free(this.memoryTracker));
        this.allocated.clear();
        this.chunks.clear();
        this.writer.close();
        this.currentChunk = null;
    }

    private void assertNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Container is closed");
    }

    private ByteBuffer addNewChunk(int size) {
        Memory memory = this.allocator.allocate(size, false, this.memoryTracker);
        ByteBuffer chunk = memory.asByteBuffer();
        this.allocated.add(memory);
        this.chunks.add(chunk);
        return chunk;
    }

    private static class OffHeapByteBufferAllocator
    implements ValueByteBufferCodec.ByteBufferAllocator {
        private final MemoryAllocator allocator;
        private final MemoryTracker memoryTracker;
        private Memory bufMemory;

        public OffHeapByteBufferAllocator(MemoryAllocator allocator, MemoryTracker memoryTracker) {
            this.allocator = allocator;
            this.memoryTracker = memoryTracker;
        }

        public ByteBuffer allocate(long capacity) {
            this.bufMemory = this.allocator.allocate(capacity, false, this.memoryTracker);
            return this.bufMemory.asByteBuffer();
        }

        public void free() {
            this.bufMemory.free(this.memoryTracker);
            this.bufMemory = null;
        }
    }
}

