/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;

class ValueIndexProxyStrategy
implements IndexProxyStrategy {
    private final IndexDescriptor indexDescriptor;
    private final IndexStatisticsStore statisticsStore;
    private final String indexUserDescription;

    ValueIndexProxyStrategy(IndexDescriptor indexDescriptor, IndexStatisticsStore statisticsStore, TokenNameLookup tokenNameLookup) {
        this.indexDescriptor = indexDescriptor;
        this.statisticsStore = statisticsStore;
        this.indexUserDescription = indexDescriptor.userDescription(tokenNameLookup);
    }

    @Override
    public IndexDescriptor getIndexDescriptor() {
        return this.indexDescriptor;
    }

    @Override
    public void removeStatisticsForIndex() {
        this.statisticsStore.removeIndex(this.indexDescriptor.getId());
    }

    @Override
    public void incrementUpdateStatisticsForIndex(long delta) {
        this.statisticsStore.incrementIndexUpdates(this.indexDescriptor.getId(), delta);
    }

    @Override
    public void replaceStatisticsForIndex(IndexSample sample) {
        this.statisticsStore.setSampleStats(this.indexDescriptor.getId(), sample);
    }

    @Override
    public String getIndexUserDescription() {
        return this.indexUserDescription;
    }
}

