/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

class IndexPopulationJobController {
    private final Set<IndexPopulationJob> populationJobs = ConcurrentHashMap.newKeySet();
    private final JobScheduler scheduler;

    IndexPopulationJobController(JobScheduler scheduler) {
        this.scheduler = scheduler;
    }

    void stop() throws InterruptedException {
        for (IndexPopulationJob job : this.populationJobs) {
            job.stop();
        }
        InterruptedException interrupted = null;
        for (IndexPopulationJob job : this.populationJobs) {
            try {
                job.awaitCompletion(0L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                interrupted = (InterruptedException)Exceptions.chain(interrupted, (Throwable)e);
            }
        }
        if (interrupted != null) {
            throw interrupted;
        }
    }

    void startIndexPopulation(IndexPopulationJob job) {
        this.populationJobs.add(job);
        job.setHandle(this.scheduler.schedule(Group.INDEX_POPULATION, job.getMonitoringParams(), (Runnable)new IndexPopulationJobWrapper(job, this)));
    }

    private void indexPopulationCompleted(IndexPopulationJob populationJob) {
        this.populationJobs.remove(populationJob);
    }

    Set<IndexPopulationJob> getPopulationJobs() {
        return this.populationJobs;
    }

    private static class IndexPopulationJobWrapper
    implements Runnable {
        private final IndexPopulationJob indexPopulationJob;
        private final IndexPopulationJobController jobController;

        IndexPopulationJobWrapper(IndexPopulationJob indexPopulationJob, IndexPopulationJobController jobController) {
            this.indexPopulationJob = indexPopulationJob;
            this.jobController = jobController;
        }

        @Override
        public void run() {
            try {
                this.indexPopulationJob.run();
            }
            finally {
                this.jobController.indexPopulationCompleted(this.indexPopulationJob);
            }
        }
    }
}

