/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Collections;
import java.util.Set;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;

public class UniquePropertyValueValidationException
extends ConstraintValidationException {
    private final Set<IndexEntryConflictException> conflicts;

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, IndexEntryConflictException conflict, TokenNameLookup tokenNameLookup) {
        this(constraint, phase, Collections.singleton(conflict), tokenNameLookup);
    }

    public UniquePropertyValueValidationException(ErrorGqlStatusObject gqlStatusObject, IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, IndexEntryConflictException conflict, TokenNameLookup tokenNameLookup) {
        this(gqlStatusObject, constraint, phase, Collections.singleton(conflict), tokenNameLookup);
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Set<IndexEntryConflictException> conflicts, TokenNameLookup tokenNameLookup) {
        super((ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", (Throwable)UniquePropertyValueValidationException.buildCauseChain(conflicts), tokenNameLookup);
        this.conflicts = conflicts;
    }

    public UniquePropertyValueValidationException(ErrorGqlStatusObject gqlStatusObject, IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Set<IndexEntryConflictException> conflicts, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", (Throwable)UniquePropertyValueValidationException.buildCauseChain(conflicts), tokenNameLookup);
        this.conflicts = conflicts;
    }

    private static IndexEntryConflictException buildCauseChain(Set<IndexEntryConflictException> conflicts) {
        IndexEntryConflictException chainedConflicts = null;
        for (IndexEntryConflictException conflict : conflicts) {
            chainedConflicts = (IndexEntryConflictException)Exceptions.chain(chainedConflicts, (Throwable)conflict);
        }
        return chainedConflicts;
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Throwable cause, TokenNameLookup tokenNameLookup) {
        super((ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", cause, tokenNameLookup);
        this.conflicts = Collections.emptySet();
    }

    public UniquePropertyValueValidationException(ErrorGqlStatusObject gqlStatusObject, IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Throwable cause, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (ConstraintDescriptor)constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", cause, tokenNameLookup);
        this.conflicts = Collections.emptySet();
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        Throwable cause = this.getCause();
        if (cause instanceof IndexEntryConflictException) {
            IndexEntryConflictException ignored = (IndexEntryConflictException)cause;
        } else {
            if (cause instanceof KernelException) {
                KernelException exc = (KernelException)cause;
                return exc.getUserMessage(tokenNameLookup);
            }
            if (cause instanceof Exception) {
                Exception exc = (Exception)cause;
                return exc.getMessage();
            }
        }
        StringBuilder message = new StringBuilder();
        boolean appendLine = false;
        for (IndexEntryConflictException conflict : this.conflicts) {
            if (appendLine) {
                message.append(System.lineSeparator());
            }
            message.append(conflict.getUserMessage(tokenNameLookup));
            appendLine = true;
        }
        return message.toString();
    }

    public Set<IndexEntryConflictException> conflicts() {
        return this.conflicts;
    }
}

