/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input.parquet;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.DummyRecordConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.parquet.ParquetColumn;
import org.neo4j.internal.batchimport.input.parquet.ParquetData;
import org.neo4j.internal.batchimport.input.parquet.ParquetInput;

class ParquetDataReader
implements Closeable {
    private final ParquetData parquetDataFile;
    private final Groups groups;
    private final IdType idType;
    private final Supplier<ZoneId> defaultTimezoneSupplier;
    private final String arrayDelimiter;
    private final ParquetFileReader reader;
    private final AtomicInteger blockCounter;
    private final MessageType schema;
    private final GroupConverter recordConverter;
    private final String createdBy;
    private final List<ColumnDescriptor> parquetColumns;

    ParquetDataReader(ParquetData parquetDataFile, Groups groups, IdType idType, Supplier<ZoneId> defaultTimezoneSupplier, String arrayDelimiter) {
        this.parquetDataFile = parquetDataFile;
        this.groups = groups;
        this.idType = idType;
        this.defaultTimezoneSupplier = defaultTimezoneSupplier;
        this.arrayDelimiter = arrayDelimiter;
        Path path = parquetDataFile.file();
        try {
            this.reader = ParquetFileReader.open((InputFile)ParquetInput.ParquetImportInputFile.of(path), (ParquetReadOptions)ParquetReadOptions.builder().build());
            FileMetaData metadata = this.reader.getFileMetaData();
            this.schema = metadata.getSchema();
            this.recordConverter = new DummyRecordConverter(this.schema).getRootConverter();
            this.createdBy = metadata.getCreatedBy();
            List<String> columnsToRead = parquetDataFile.columns().stream().map(ParquetColumn::columnName).toList();
            this.parquetColumns = this.schema.getColumns().stream().filter(c -> columnsToRead.contains(c.getPath()[0])).toList();
            this.blockCounter = new AtomicInteger(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<List<Object>> next() throws IOException {
        int nextRowGroupIndex = this.blockCounter.getAndIncrement();
        if (nextRowGroupIndex >= this.reader.getRowGroups().size()) {
            return null;
        }
        return new ParquetRowGroupReader(this.reader.readRowGroup(nextRowGroupIndex));
    }

    public ParquetData getParquetDataFile() {
        return this.parquetDataFile;
    }

    public Groups getGroups() {
        return this.groups;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public Supplier<ZoneId> getDefaultTimezoneSupplier() {
        return this.defaultTimezoneSupplier;
    }

    public String getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private class ParquetRowGroupReader
    implements Iterator<List<Object>> {
        private final List<ColumnReader> columnReaders;
        private final long rowCount;
        private long rowIndex;

        ParquetRowGroupReader(PageReadStore store) {
            this.rowCount = store.getRowCount();
            ColumnReadStoreImpl columnReadStore = new ColumnReadStoreImpl(store, ParquetDataReader.this.recordConverter, ParquetDataReader.this.schema, ParquetDataReader.this.createdBy);
            this.columnReaders = ParquetDataReader.this.parquetColumns.stream().map(arg_0 -> ((ColumnReadStoreImpl)columnReadStore).getColumnReader(arg_0)).toList();
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex < this.rowCount;
        }

        @Override
        public List<Object> next() {
            ArrayList<Object> result = new ArrayList<Object>();
            for (ColumnReader columnReader : this.columnReaders) {
                result.add(ParquetRowGroupReader.readValue(columnReader));
                columnReader.consume();
                if (columnReader.getCurrentRepetitionLevel() == 0) continue;
                throw new IllegalStateException("Unexpected repetition");
            }
            ++this.rowIndex;
            return result;
        }

        private static Object readValue(ColumnReader columnReader) {
            ColumnDescriptor column = columnReader.getDescriptor();
            PrimitiveType primitiveType = column.getPrimitiveType();
            int maxDefinitionLevel = column.getMaxDefinitionLevel();
            if (columnReader.getCurrentDefinitionLevel() == maxDefinitionLevel) {
                return switch (primitiveType.getPrimitiveTypeName()) {
                    default -> throw new IncompatibleClassChangeError();
                    case PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, PrimitiveType.PrimitiveTypeName.INT96 -> primitiveType.stringifier().stringify(columnReader.getBinary());
                    case PrimitiveType.PrimitiveTypeName.BOOLEAN -> columnReader.getBoolean();
                    case PrimitiveType.PrimitiveTypeName.DOUBLE -> columnReader.getDouble();
                    case PrimitiveType.PrimitiveTypeName.FLOAT -> Float.valueOf(columnReader.getFloat());
                    case PrimitiveType.PrimitiveTypeName.INT32 -> columnReader.getInteger();
                    case PrimitiveType.PrimitiveTypeName.INT64 -> columnReader.getLong();
                };
            }
            return null;
        }
    }
}

