/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.CountsValue;
import org.neo4j.io.IOUtils;
import org.neo4j.logging.InternalLogProvider;

class TreeWriter
implements CountUpdater.CountWriter {
    private final Writer<CountsKey, CountsValue> treeWriter;
    private final CountsValue value = new CountsValue();
    private final InternalLogProvider userLogProvider;
    private final RememberingReplacingMerger merger = new RememberingReplacingMerger();

    TreeWriter(Writer<CountsKey, CountsValue> treeWriter, InternalLogProvider userLogProvider) {
        this.treeWriter = treeWriter;
        this.userLogProvider = userLogProvider;
    }

    @Override
    public boolean write(CountsKey key, long delta) {
        return this.merge(this.treeWriter, key, this.value.initialize(delta));
    }

    @Override
    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new Writer[]{this.treeWriter});
    }

    private boolean merge(Writer<CountsKey, CountsValue> writer, CountsKey key, CountsValue value) {
        if (value.count > 0L) {
            writer.merge((Object)key, (Object)value, (ValueMerger)this.merger);
            return this.merger.oldMergeValue.count == 0L;
        }
        if (value.count == 0L) {
            writer.remove((Object)key);
            return true;
        }
        this.userLogProvider.getLog(this.getClass()).error("Key '" + key + "' has a negative count.\nThis is a serious error which is typically caused by a store corruption\nEven thought the database will continue operating, it will do so with reduced functionality\nThe best cause of action is running the consistency checker, fixing the corruption and rebuilding the count store\nCounts for the problematic key will not be available until the count store is rebuilt.\n");
        writer.merge((Object)key, (Object)new CountsValue().initialize(-1L), (ValueMerger)this.merger);
        return false;
    }

    private static class RememberingReplacingMerger
    implements ValueMerger<CountsKey, CountsValue> {
        private final CountsValue oldMergeValue = new CountsValue();

        private RememberingReplacingMerger() {
        }

        public ValueMerger.MergeResult merge(CountsKey existingKey, CountsKey newKey, CountsValue existingValue, CountsValue newValue) {
            this.oldMergeValue.initialize(existingValue.count);
            return ValueMerger.MergeResult.REPLACED;
        }
    }
}

