/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class StaticContentFilter
implements Filter {
    private final String contentSecurityPolicyHeader;

    public StaticContentFilter(String contentSecurityPolicyHeader) {
        this.contentSecurityPolicyHeader = contentSecurityPolicyHeader;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (response.getHeader("Cache-Control") == null) {
            response.addHeader("Cache-Control", "no-store");
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Content-Security-Policy", this.contentSecurityPolicyHeader);
            response.addHeader("X-Frame-Options", "DENY");
            response.addHeader("X-Content-Type-Options", "nosniff");
            response.addHeader("X-XSS-Protection", "1; mode=block");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

