/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Objects;

public abstract class Pair<T1, T2> {
    public static <T1, T2> Pair<T1, T2> pair(final T1 first, final T2 other) {
        return new Pair<T1, T2>(){

            @Override
            public T1 first() {
                return first;
            }

            @Override
            public T2 other() {
                return other;
            }
        };
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 other) {
        return Pair.pair(first, other);
    }

    Pair() {
    }

    public abstract T1 first();

    public abstract T2 other();

    public String toString() {
        return "(" + this.first() + ", " + this.other() + ")";
    }

    public int hashCode() {
        return 31 * Pair.hashCode(this.first()) | Pair.hashCode(this.other());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair that = (Pair)obj;
            return Objects.equals(this.other(), that.other()) && Objects.equals(this.first(), that.first());
        }
        return false;
    }

    private static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }
}

