/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Iterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;

public class LimitingIterator<T>
extends PrefetchingIterator<T> {
    private int returned;
    private final Iterator<T> source;
    private final int limit;

    LimitingIterator(Iterator<T> source, int limit) {
        this.source = source;
        this.limit = limit;
    }

    @Override
    protected T fetchNextOrNull() {
        if (!this.source.hasNext() || this.returned >= this.limit) {
            return null;
        }
        try {
            T t = this.source.next();
            return t;
        }
        finally {
            ++this.returned;
        }
    }
}

