/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.EmptyStackException;
import org.neo4j.collection.trackable.HeapTrackingArrayList;

public class HeapTrackingStack<T>
implements AutoCloseable {
    private final HeapTrackingArrayList<T> delegate;

    public HeapTrackingStack(HeapTrackingArrayList<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public T peek() {
        int size = this.delegate.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return this.delegate.get(size - 1);
    }

    public void push(T item) {
        this.delegate.add(item);
    }

    public T pop() {
        int size = this.delegate.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return this.delegate.remove(size - 1);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }
}

