/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.util.Preconditions;

public class RangeLongIterator
implements LongIterator {
    private final long[] array;
    private final int stopIndex;
    private int currentIndex;

    public RangeLongIterator(long[] array, int start, int size) {
        Preconditions.requireBetween((int)start, (int)0, (int)array.length);
        Preconditions.requireBetween((int)(start + size), (int)0, (int)(array.length + 1));
        this.array = array;
        this.currentIndex = start;
        this.stopIndex = start + size;
    }

    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.currentIndex++];
    }

    public boolean hasNext() {
        return this.currentIndex < this.stopIndex;
    }
}

