/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.NoSuchElementException;
import org.neo4j.collection.ResourceRawIterator;

public abstract class AbstractPrefetchingRawIterator<T, EXCEPTION extends Exception>
implements ResourceRawIterator<T, EXCEPTION> {
    private boolean hasFetchedNext;
    private T nextObject;

    @Override
    public boolean hasNext() throws EXCEPTION {
        return this.peek() != null;
    }

    public T peek() throws EXCEPTION {
        if (this.hasFetchedNext) {
            return this.nextObject;
        }
        this.nextObject = this.fetchNextOrNull();
        this.hasFetchedNext = true;
        return this.nextObject;
    }

    @Override
    public T next() throws EXCEPTION {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextObject;
        this.nextObject = null;
        this.hasFetchedNext = false;
        return result;
    }

    protected abstract T fetchNextOrNull() throws EXCEPTION;

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

