/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.context;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.io.pagecache.context.VersionContext;

public class FixedVersionContext
implements VersionContext {
    private static final long INVALID_TRANSACTION_ID = 0L;
    public static final VersionContext EMPTY_VERSION_CONTEXT = new FixedVersionContext(0L);
    private final long committingTransactionId;

    public FixedVersionContext(long committingTransactionId) {
        this.committingTransactionId = committingTransactionId;
    }

    @Override
    public void initRead() {
    }

    @Override
    public void initWrite(long committingTransactionId) {
    }

    @Override
    public long committingTransactionId() {
        return this.committingTransactionId;
    }

    @Override
    public long lastClosedTransactionId() {
        return Long.MAX_VALUE;
    }

    @Override
    public long highestClosed() {
        return Long.MAX_VALUE;
    }

    @Override
    public void markAsDirty() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public long[] notVisibleTransactionIds() {
        return ArrayUtils.EMPTY_LONG_ARRAY;
    }

    @Override
    public long oldestVisibleTransactionNumber() {
        return 0L;
    }

    @Override
    public void refreshVisibilityBoundaries() {
    }

    @Override
    public void observedChainHead(long headVersion) {
    }

    @Override
    public boolean invisibleHeadObserved() {
        return false;
    }

    @Override
    public void resetObsoleteHeadState() {
    }

    @Override
    public void markHeadInvisible() {
    }

    @Override
    public long chainHeadVersion() {
        return Long.MIN_VALUE;
    }

    @Override
    public boolean initializedForWrite() {
        return this.committingTransactionId != 0L;
    }
}

