/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.context;

import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.context.OldestTransactionIdFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class CursorContextFactory {
    public static final CursorContextFactory NULL_CONTEXT_FACTORY = new CursorContextFactory(PageCacheTracer.NULL, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
    private final PageCacheTracer cacheTracer;
    private final VersionContextSupplier versionContextSupplier;

    public CursorContextFactory(PageCacheTracer cacheTracer, VersionContextSupplier versionContextSupplier) {
        this.cacheTracer = cacheTracer;
        this.versionContextSupplier = versionContextSupplier;
    }

    public CursorContext create(String tag) {
        return new CursorContext(this, this.cacheTracer.createPageCursorTracer(tag), this.versionContextSupplier.createVersionContext());
    }

    public CursorContext create(String tag, VersionContext versionContext) {
        return new CursorContext(this, this.cacheTracer.createPageCursorTracer(tag), versionContext);
    }

    public CursorContext create(PageCursorTracer cursorTracer) {
        return new CursorContext(this, cursorTracer, this.versionContextSupplier.createVersionContext());
    }

    public void init(TransactionIdSnapshotFactory transactionIdSnapshotFactory, OldestTransactionIdFactory oldestTransactionIdFactory) {
        this.versionContextSupplier.init(transactionIdSnapshotFactory, oldestTransactionIdFactory);
    }
}

