/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FabricSecondaryException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class Exceptions {
    public static RuntimeException transform(ErrorGqlStatusObject gqlStatusObject, Status defaultStatus, Throwable t) {
        return Exceptions.transform(gqlStatusObject, defaultStatus, t, null);
    }

    public static RuntimeException transform(ErrorGqlStatusObject fallbackGqlStatusObject, Status defaultStatus, Throwable t, Long queryId) {
        Throwable unwrapped = reactor.core.Exceptions.unwrap((Throwable)t);
        unwrapped = Exceptions.transformComposite(unwrapped);
        String message = unwrapped.getMessage();
        if (unwrapped instanceof Status.HasStatus) {
            if (unwrapped instanceof RuntimeException) {
                if (queryId == null) {
                    return (RuntimeException)unwrapped;
                }
                if (unwrapped instanceof HasQuery) {
                    ((HasQuery)unwrapped).setQuery(queryId);
                    return (RuntimeException)unwrapped;
                }
            }
            if (unwrapped instanceof ErrorGqlStatusObject) {
                ErrorGqlStatusObject gqlStatusObjectOfUnwrapped = (ErrorGqlStatusObject)unwrapped;
                return new FabricException(gqlStatusObjectOfUnwrapped, ((Status.HasStatus)unwrapped).status(), message, unwrapped, queryId);
            }
            return new FabricException(((Status.HasStatus)unwrapped).status(), message, unwrapped, queryId);
        }
        return new FabricException(fallbackGqlStatusObject, defaultStatus, message, unwrapped, queryId);
    }

    public static RuntimeException transformTransactionStartFailure(Throwable t) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N06).build();
        return Exceptions.transform(gql, (Status)Status.Transaction.TransactionStartFailed, t);
    }

    public static RuntimeException transformUnexpectedError(Status defaultStatus, Throwable t) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).build();
        return Exceptions.transform(gql, defaultStatus, t);
    }

    public static RuntimeException transformUnexpectedError(Status defaultStatus, Throwable t, long queryId) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).build();
        return Exceptions.transform(gql, defaultStatus, t, queryId);
    }

    private static Throwable transformComposite(Throwable potentialComposite) {
        List unwrappedExceptions = reactor.core.Exceptions.unwrapMultiple((Throwable)potentialComposite);
        ArrayList primaryExceptions = new ArrayList();
        ArrayList secondaryExceptions = new ArrayList();
        unwrappedExceptions.forEach(exception -> {
            if (exception instanceof FabricSecondaryException) {
                secondaryExceptions.add((FabricSecondaryException)((Object)((Object)exception)));
            } else {
                primaryExceptions.add(exception);
            }
        });
        if (!primaryExceptions.isEmpty()) {
            Throwable result = (Throwable)primaryExceptions.get(0);
            IntStream.range(1, primaryExceptions.size()).forEach(i -> result.addSuppressed((Throwable)primaryExceptions.get(i)));
            return result;
        }
        HashSet<FabricException> uniqueExceptions = new HashSet<FabricException>();
        FabricException result = ((FabricSecondaryException)((Object)secondaryExceptions.get(0))).getPrimaryException();
        uniqueExceptions.add(result);
        IntStream.range(1, secondaryExceptions.size()).mapToObj(secondaryExceptions::get).map(FabricSecondaryException::getPrimaryException).filter(exception -> !uniqueExceptions.contains(exception)).forEach(arg_0 -> Exceptions.lambda$transformComposite$3((Throwable)((Object)result), uniqueExceptions, arg_0));
        return result;
    }

    private static /* synthetic */ void lambda$transformComposite$3(Throwable result, Set uniqueExceptions, FabricException exception) {
        result.addSuppressed((Throwable)((Object)exception));
        uniqueExceptions.add(exception);
    }
}

