/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.List;
import org.neo4j.fabric.bookmark.LocalBookmark;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.FabricKernelTransaction;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.fabric.transaction.parent.CompoundTransaction;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.api.exceptions.Status;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AutocommitLocalStatementResult
implements StatementResult,
CompoundTransaction.AutocommitQuery {
    private final StatementResult result;
    private final FabricKernelTransaction transaction;
    private final TransactionBookmarkManager bookmarkManager;
    private final LocalGraphTransactionIdTracker transactionIdTracker;
    private final Location.Local location;

    public AutocommitLocalStatementResult(StatementResult result, FabricKernelTransaction transaction, TransactionBookmarkManager bookmarkManager, LocalGraphTransactionIdTracker transactionIdTracker, Location.Local location) {
        this.result = result;
        this.transaction = transaction;
        this.bookmarkManager = bookmarkManager;
        this.transactionIdTracker = transactionIdTracker;
        this.location = location;
    }

    @Override
    public List<String> columns() {
        return this.result.columns();
    }

    @Override
    public Flux<Record> records() {
        return this.result.records().doOnComplete(this::doCommit);
    }

    @Override
    public Mono<Summary> summary() {
        return this.result.summary();
    }

    @Override
    public Mono<QueryExecutionType> executionType() {
        return this.result.executionType();
    }

    @Override
    public void terminate(Status reason) {
        this.transaction.terminate(reason);
    }

    private void doCommit() {
        long transactionId = this.transactionIdTracker.getTransactionId(this.location);
        this.transaction.commit();
        this.bookmarkManager.localTransactionCommitted(this.location, new LocalBookmark(transactionId));
    }
}

