/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bookmark;

import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.bolt.txtracking.TransactionIdTracker;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.fabric.executor.Location;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;

public class LocalGraphTransactionIdTracker {
    private final TransactionIdTracker transactionIdTracker;
    private final DatabaseIdRepository databaseIdRepository;
    private volatile Duration bookmarkTimeout;

    public LocalGraphTransactionIdTracker(TransactionIdTracker transactionIdTracker, DatabaseIdRepository databaseIdRepository, Config config) {
        this.transactionIdTracker = transactionIdTracker;
        this.databaseIdRepository = databaseIdRepository;
        this.bookmarkTimeout = (Duration)config.get(GraphDatabaseSettings.bookmark_ready_timeout);
        config.addListener(GraphDatabaseSettings.bookmark_ready_timeout, (before, after) -> {
            this.bookmarkTimeout = after;
        });
    }

    public void awaitSystemGraphUpToDate(long transactionId) {
        this.awaitGraphUpToDate(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID, transactionId);
    }

    public void awaitGraphUpToDate(Location.Local location, long transactionId) {
        NamedDatabaseId namedDatabaseId = this.getNamedDatabaseId(location);
        this.awaitGraphUpToDate(namedDatabaseId, transactionId);
    }

    private void awaitGraphUpToDate(NamedDatabaseId namedDatabaseId, long transactionId) {
        this.transactionIdTracker.awaitUpToDate(namedDatabaseId, transactionId, this.bookmarkTimeout);
    }

    public long getTransactionId(Location.Local location) {
        NamedDatabaseId namedDatabaseId = this.getNamedDatabaseId(location);
        return this.transactionIdTracker.newestTransactionId(namedDatabaseId);
    }

    private NamedDatabaseId getNamedDatabaseId(Location.Local location) {
        DatabaseId databaseId2 = DatabaseIdFactory.from((UUID)location.getUuid());
        Optional namedDatabaseId = this.databaseIdRepository.getById(databaseId2);
        if (namedDatabaseId.isEmpty()) {
            throw new IllegalArgumentException("A local graph could not be mapped to a database");
        }
        return (NamedDatabaseId)namedDatabaseId.get();
    }
}

