/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.configuration;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.neo4j.bolt.transport.configuration.ServerConfigurationProvider;

public class NioConfigurationProvider
implements ServerConfigurationProvider {
    public static final NioConfigurationProvider INSTANCE = new NioConfigurationProvider();

    private NioConfigurationProvider() {
    }

    @Override
    public EventLoopGroup createEventLoopGroup(ThreadFactory threadFactory) {
        return new NioEventLoopGroup(0, threadFactory);
    }

    @Override
    public Class<? extends ServerChannel> getChannelClass(SocketAddress socketAddress) {
        if (socketAddress instanceof DomainSocketAddress) {
            throw new IllegalArgumentException("Unix Domain Sockets cannot be used with Nio Configuration.");
        }
        return NioServerSocketChannel.class;
    }
}

