/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import java.time.ZoneOffset;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.utils.TemporalUtil;

public final class TimeReader<CTX>
implements StructReader<CTX, TimeValue> {
    private static final TimeReader<?> INSTANCE = new TimeReader();

    private TimeReader() {
    }

    public static <CTX> TimeReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.TIME.getTag();
    }

    @Override
    public TimeValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 2L) {
            throw new IllegalStructSizeException(2L, header.length());
        }
        long nanoOfDay = buffer.readInt();
        long offsetSeconds = buffer.readInt();
        if (offsetSeconds > Integer.MAX_VALUE || offsetSeconds < Integer.MIN_VALUE) {
            throw IllegalStructArgumentException.wrongTypeForFieldNameOrOutOfRange("tz_offset_seconds", "INTEGER", Integer.MIN_VALUE, Integer.MAX_VALUE, offsetSeconds, "Value is out of bounds");
        }
        return TimeValue.time((long)TemporalUtil.nanosOfDayToUTC((long)nanoOfDay, (int)((int)offsetSeconds)), (ZoneOffset)ZoneOffset.ofTotalSeconds((int)offsetSeconds));
    }
}

