/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.LocalTimeValue;

public final class LocalTimeReader<CTX>
implements StructReader<CTX, LocalTimeValue> {
    private static final LocalTimeReader<?> INSTANCE = new LocalTimeReader();

    private LocalTimeReader() {
    }

    public static <CTX> LocalTimeReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.LOCAL_TIME.getTag();
    }

    @Override
    public LocalTimeValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        long nanoOfDay = buffer.readInt();
        return LocalTimeValue.localTime((long)nanoOfDay);
    }
}

