/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.request.connection;

import java.util.Map;
import java.util.Objects;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public final class RoutingContext {
    private final boolean serverRoutingEnabled;
    private final Map<String, String> parameters;

    public RoutingContext(boolean serverRoutingEnabled, Map<String, String> parameters) {
        this.serverRoutingEnabled = serverRoutingEnabled;
        this.parameters = parameters;
    }

    public boolean isServerRoutingEnabled() {
        return this.serverRoutingEnabled;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RoutingContext that = (RoutingContext)other;
        return this.serverRoutingEnabled == that.serverRoutingEnabled && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.serverRoutingEnabled, this.parameters);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public MapValue parametersAsMapValue() {
        MapValueBuilder builder = new MapValueBuilder();
        this.parameters.forEach((key, value) -> builder.add(key, (AnyValue)Values.stringValue((String)value)));
        return builder.build();
    }

    public String toString() {
        return "RoutingContext[serverRoutingEnabled=" + this.serverRoutingEnabled + ", parameters=" + this.parameters + "]";
    }
}

