/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.transition.transaction;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.protocol.common.fsm.States;
import org.neo4j.bolt.protocol.common.fsm.error.TransactionStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.fsm.transition.transaction.TransactionalStateTransition;
import org.neo4j.bolt.protocol.common.message.request.transaction.CommitMessage;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.error.TransactionException;

public final class CommitTransactionalStateTransition
extends TransactionalStateTransition<CommitMessage> {
    private static final CommitTransactionalStateTransition INSTANCE = new CommitTransactionalStateTransition();

    private CommitTransactionalStateTransition() {
        super(CommitMessage.class);
    }

    public static CommitTransactionalStateTransition getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateReference process(Context ctx, Transaction tx, CommitMessage message, ResponseHandler handler) throws StateMachineException {
        String bookmark;
        try {
            try {
                bookmark = tx.commit();
            }
            finally {
                ctx.connection().closeTransaction();
                ctx.connection().clearImpersonation();
            }
        }
        catch (TransactionException ex) {
            throw new TransactionStateTransitionException(ex);
        }
        handler.onBookmark(bookmark);
        return States.READY;
    }
}

