/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.Set;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.negotiation.message.ModernProtocolNegotiationFinalizeMessage;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.negotiation.util.BitMask;
import org.neo4j.bolt.negotiation.util.NegotiationEncodingUtil;
import org.neo4j.memory.HeapEstimator;

public final class ModernProtocolNegotiationFinalizeMessageDecoder
extends ByteToMessageDecoder {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ModernProtocolNegotiationFinalizeMessageDecoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Set<ProtocolCapability> capabilities;
        if (!in.isReadable(5)) {
            return;
        }
        in.markReaderIndex();
        ProtocolVersion selectedVersion = new ProtocolVersion(in.readInt());
        if (selectedVersion.hasRange()) {
            throw new IllegalArgumentException("Illegal version selection: Selection cannot include range");
        }
        if (!NegotiationEncodingUtil.isBitMaskReadable(in, 32)) {
            in.resetReaderIndex();
            return;
        }
        BitMask capabilityMask = NegotiationEncodingUtil.readBitMask(in);
        try {
            capabilities = ProtocolCapability.fromBitMask(capabilityMask);
        }
        finally {
            ReferenceCountUtil.release((Object)capabilityMask);
        }
        out.add(new ModernProtocolNegotiationFinalizeMessage(selectedVersion, capabilities));
    }
}

