/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.event;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.bolt.event.AbstractEventPublisher;

public class CopyOnWriteEventPublisher<L>
extends AbstractEventPublisher<L> {
    private final Lock lock = new ReentrantLock();

    public CopyOnWriteEventPublisher() {
        super(new CopyOnWriteArrayList());
    }

    @Override
    public void registerListener(L listener) {
        this.lock.lock();
        try {
            super.registerListener(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeListener(L listener) {
        this.lock.lock();
        try {
            super.removeListener(listener);
        }
        finally {
            this.lock.unlock();
        }
    }
}

