/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.completions;

import java.util.Optional;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.shell.completions.DbInfo;
import org.neo4j.shell.completions.QueryPoller;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.state.BoltStateHandler;
import org.neo4j.shell.util.Version;
import org.neo4j.shell.util.Versions;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DbInfoImpl
extends DbInfo {
    QueryPoller queryPoller;
    BoltStateHandler boltStateHandler;
    boolean completionsEnabledByConfig;

    private void initializeQueryPoller() {
        this.queryPoller = new QueryPoller(this.boltStateHandler);
        QueryPoller.PollingQuery fetchDataSummary = new QueryPoller.PollingQuery(QueryPoller.fetchDataSummary, records -> {
            this.labels = ((Record)records.get(0)).get("result").asList(Value::asString);
            this.relationshipTypes = ((Record)records.get(1)).get("result").asList(Value::asString);
            this.propertyKeys = ((Record)records.get(2)).get("result").asList(Value::asString);
        });
        QueryPoller.PollingQuery fetchProcedures = new QueryPoller.PollingQuery(QueryPoller.fetchProcedures, records -> {
            this.procedures = records.stream().map(r -> r.get("name").asString()).toList();
        });
        QueryPoller.PollingQuery fetchFunctions = new QueryPoller.PollingQuery(QueryPoller.fetchFunctions, records -> {
            this.functions = records.stream().map(r -> r.get("name").asString()).toList();
        });
        QueryPoller.PollingQuery fetchDatabases = new QueryPoller.PollingQuery(QueryPoller.fetchDatabases, records -> {
            this.databaseNames = records.stream().map(r -> r.get("name").asString()).toList();
            this.aliasNames = records.stream().flatMap(r -> r.get("aliases").asList(Value::toString).stream().map(alias -> {
                if (alias.startsWith("\"") && alias.endsWith("\"")) {
                    return alias.substring(1, alias.length() - 1);
                }
                return alias;
            })).toList();
        });
        QueryPoller.PollingQuery fetchRoles = new QueryPoller.PollingQuery(QueryPoller.fetchRoles, records -> {
            this.roleNames = records.stream().map(r -> r.get("role").asString()).toList();
        });
        QueryPoller.PollingQuery fetchUsers = new QueryPoller.PollingQuery(QueryPoller.fetchUsers, records -> {
            this.userNames = records.stream().map(r -> r.get("user").asString()).toList();
        });
        this.queryPoller.startPolling(fetchDataSummary, fetchProcedures, fetchFunctions, fetchDatabases, fetchRoles, fetchUsers);
    }

    public DbInfoImpl(ParameterService parameterService, BoltStateHandler boltStateHandler, boolean completionsEnabledByConfig) {
        super(parameterService);
        this.completionsEnabledByConfig = completionsEnabledByConfig;
        this.boltStateHandler = boltStateHandler;
        if (this.completionsEnabled()) {
            this.initializeQueryPoller();
        }
    }

    @Override
    public boolean completionsEnabled() {
        if (this.versionCompatibleWithCompletions.isEmpty() && this.boltStateHandler.isConnected()) {
            Version serverVersion = Versions.version(this.boltStateHandler.getServerVersion());
            boolean enableCompletions = serverVersion.compareTo(Versions.version("5.0.0")) >= 0;
            this.versionCompatibleWithCompletions = Optional.of(enableCompletions);
        }
        return this.versionCompatibleWithCompletions.orElse(false) != false && this.completionsEnabledByConfig;
    }

    @Override
    public void resumePolling() {
        if (this.queryPoller != null) {
            this.queryPoller.resumePolling();
        } else if (this.completionsEnabled()) {
            this.initializeQueryPoller();
        }
    }

    @Override
    public void stopPolling() {
        if (this.queryPoller != null) {
            this.queryPoller.stopPolling();
        }
    }

    @Override
    public void close() throws Exception {
        this.cleanDbInfo();
        if (this.queryPoller != null) {
            this.queryPoller.close();
            this.queryPoller = null;
        }
    }
}

