/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.neo4j.kernel.api.impl.schema.ValueEncoding;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class TextDocumentStructure {
    public static final String NODE_ID_KEY = "id";
    private static final ThreadLocal<DocWithId> perThreadDocument = ThreadLocal.withInitial(DocWithId::new);
    public static final String DELIMITER = "\u001f";

    private TextDocumentStructure() {
    }

    private static DocWithId reuseDocument(long nodeId) {
        DocWithId doc = perThreadDocument.get();
        doc.setId(nodeId);
        return doc;
    }

    public static Document documentRepresentingProperties(long nodeId, Value ... values) {
        DocWithId document = TextDocumentStructure.reuseDocument(nodeId);
        document.setValues(values);
        return document.document;
    }

    public static MatchAllDocsQuery newScanQuery() {
        return new MatchAllDocsQuery();
    }

    public static Query newSeekQuery(Value ... values) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (int i = 0; i < values.length; ++i) {
            builder.add(ValueEncoding.String.encodeQuery(values[i], i), BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    public static Term newTermForChangeOrRemove(long nodeId) {
        return new Term(NODE_ID_KEY, "" + nodeId);
    }

    public static long getNodeId(Document from) {
        return Long.parseLong(from.get(NODE_ID_KEY));
    }

    public static boolean useFieldForUniquenessVerification(String fieldName) {
        return !NODE_ID_KEY.equals(fieldName) && ValueEncoding.fieldPropertyNumber(fieldName) == 0;
    }

    private static class DocWithId {
        private final Document document;
        private final Field idField;
        private final Field idValueField;
        private Field[] reusableValueFields = new Field[0];

        private DocWithId() {
            this.idField = new StringField(TextDocumentStructure.NODE_ID_KEY, "", Field.Store.YES);
            this.idValueField = new NumericDocValuesField(TextDocumentStructure.NODE_ID_KEY, 0L);
            this.document = new Document();
            this.document.add((IndexableField)this.idField);
            this.document.add((IndexableField)this.idValueField);
        }

        private void setId(long id) {
            this.idField.setStringValue(Long.toString(id));
            this.idValueField.setLongValue(id);
        }

        private void setValues(Value ... values) {
            this.removeAllValueFields();
            int neededLength = values.length * ValueEncoding.values().length;
            if (this.reusableValueFields.length < neededLength) {
                this.reusableValueFields = new Field[neededLength];
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[i].valueGroup() != ValueGroup.TEXT) continue;
                Field reusableField = this.getFieldWithValue(i, values[i]);
                this.document.add((IndexableField)reusableField);
            }
        }

        private void removeAllValueFields() {
            this.document.clear();
            this.document.add((IndexableField)this.idField);
            this.document.add((IndexableField)this.idValueField);
        }

        private Field getFieldWithValue(int propertyNumber, Value value) {
            int reuseId = propertyNumber * ValueEncoding.values().length + ValueEncoding.String.ordinal();
            String key = ValueEncoding.String.key(propertyNumber);
            Field reusableField = this.reusableValueFields[reuseId];
            if (reusableField == null) {
                this.reusableValueFields[reuseId] = reusableField = ValueEncoding.String.encodeField(key, value);
            } else {
                ValueEncoding.String.setFieldValue(value, reusableField);
            }
            return reusableField;
        }
    }
}

