/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexReader;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;

public abstract class AbstractTextIndexReader
extends AbstractLuceneIndexReader {
    private final SearcherReference searcherReference;

    protected AbstractTextIndexReader(IndexDescriptor descriptor, SearcherReference searcherReference, IndexUsageTracking usageTracker) {
        super(descriptor, usageTracker);
        this.searcherReference = searcherReference;
    }

    @Override
    protected IndexProgressor indexProgressor(Query query, IndexQueryConstraints constraints, IndexProgressor.EntityValueClient client) {
        return this.search(this.getIndexSearcher(), query).getIndexProgressor(this.entityIdFieldKey(), client);
    }

    @Override
    public void close() {
        try (SearcherReference searcherReference = this.searcherReference;){
            super.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    protected IndexSearcher getIndexSearcher() {
        return this.searcherReference.getIndexSearcher();
    }
}

