/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;

class SearchEnvelope {
    private long[] min;
    private long[] max;
    private int nbrDim;

    SearchEnvelope(SpaceFillingCurve curve, Envelope referenceEnvelope) {
        this.min = curve.getNormalizedCoord(referenceEnvelope.getMin());
        this.max = curve.getNormalizedCoord(referenceEnvelope.getMax());
        this.nbrDim = referenceEnvelope.getDimension();
        int i = 0;
        while (i < this.nbrDim) {
            int n = i++;
            this.max[n] = this.max[n] + 1L;
        }
    }

    private SearchEnvelope(long[] min, long[] max) {
        this.min = min;
        this.max = max;
        this.nbrDim = min.length;
    }

    SearchEnvelope(long min, long max, int nbrDim) {
        this.nbrDim = nbrDim;
        this.min = new long[nbrDim];
        this.max = new long[nbrDim];
        for (int dim = 0; dim < nbrDim; ++dim) {
            this.min[dim] = min;
            this.max[dim] = max;
        }
    }

    SearchEnvelope quadrant(int npoint) {
        long[] newMin = new long[this.nbrDim];
        long[] newMax = new long[this.nbrDim];
        for (int dim = 0; dim < this.nbrDim; ++dim) {
            long extent = (this.max[dim] - this.min[dim]) / 2L;
            int v = npoint >> this.nbrDim - dim - 1 & 1;
            newMin[dim] = this.min[dim] + (long)v * extent;
            newMax[dim] = this.min[dim] + (long)(v + 1) * extent;
        }
        return new SearchEnvelope(newMin, newMax);
    }

    boolean contains(long[] coord) {
        for (int dim = 0; dim < this.nbrDim; ++dim) {
            if (coord[dim] >= this.min[dim] && coord[dim] < this.max[dim]) continue;
            return false;
        }
        return true;
    }

    boolean intersects(SearchEnvelope other) {
        for (int dim = 0; dim < this.nbrDim; ++dim) {
            if (this.max[dim] > other.min[dim] && other.max[dim] > this.min[dim]) continue;
            return false;
        }
        return true;
    }

    double fractionOf(SearchEnvelope other) {
        double fraction = 1.0;
        for (int i = 0; i < this.nbrDim; ++i) {
            long min = Math.max(this.min[i], other.min[i]);
            long max = Math.min(this.max[i], other.max[i]);
            double innerFraction = (double)(max - min) / (double)(other.max[i] - other.min[i]);
            fraction *= innerFraction;
        }
        return fraction;
    }

    public long getArea() {
        long area = 1L;
        for (int i = 0; i < this.nbrDim; ++i) {
            area *= this.max[i] - this.min[i];
        }
        return area;
    }
}

