/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import java.util.function.Function;
import javax.net.ssl.SSLEngine;

public class EssentialEngineModifications
implements Function<SSLEngine, SSLEngine> {
    private final String[] tlsVersions;
    private final boolean isClient;

    public EssentialEngineModifications(String[] tlsVersions, boolean isClient) {
        this.tlsVersions = tlsVersions;
        this.isClient = isClient;
    }

    @Override
    public SSLEngine apply(SSLEngine sslEngine) {
        if (this.tlsVersions != null) {
            sslEngine.setEnabledProtocols(this.tlsVersions);
        }
        sslEngine.setUseClientMode(this.isClient);
        return sslEngine;
    }
}

