/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.cli.PathOptions;
import org.neo4j.cloud.storage.SchemeFileSystemAbstraction;
import org.neo4j.cloud.storage.StoragePath;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.ConsistencyCheckOptions;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.dbms.archive.CheckDatabase;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="check", header={"Check the consistency of a database."}, description={"This command allows for checking the consistency of a database, or a dump or backup thereof.\nIt cannot be used with a database which is currently in use.\n\nSome checks can be quite expensive, so it may be useful to turn some of them off\nfor very large databases. Increasing the heap size can also be a good idea.\nSee 'neo4j-admin help' for details."}, sortOptions=false)
public class CheckCommand
extends AbstractAdminCommand {
    private final ConsistencyCheckService consistencyCheckService;
    @CommandLine.Parameters(index="0", description={"Name of the database to check."}, converter={Converters.DatabaseNameConverter.class})
    private NormalizedDatabaseName database;
    @CommandLine.Option(names={"--force"}, fallbackValue="true", description={"Force a consistency check to be run, despite resources, and may run a more thorough check."})
    private boolean force;
    @CommandLine.Option(names={"--check-tx-logs"}, fallbackValue="true", hidden=true, description={"Hidden option to be used by upgrade-tests. Checks that the transaction log content and headers are correct in respect to version changes and rotations."})
    private boolean additionalTxLogCheck;
    @CommandLine.Mixin
    private ConsistencyCheckOptions options;
    @CommandLine.ArgGroup
    private SourceOptions sourceOptions;
    protected Config config;
    private ConsistencyFlags flags;

    public CheckCommand(ExecutionContext ctx) {
        this(ctx, new ConsistencyCheckService(null));
    }

    @VisibleForTesting
    public CheckCommand(ExecutionContext ctx, ConsistencyCheckService consistencyCheckService) {
        super(ctx);
        this.consistencyCheckService = consistencyCheckService;
    }

    protected Optional<String> commandConfigName() {
        return Optional.of("database-check");
    }

    public void execute() {
        this.validateAndConstructArgs();
        ConsistencyCheckService.Result result = this.checkWith(this.config, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        if (!result.isSuccessful()) {
            throw new CommandFailedException("Inconsistencies found. See '%s' for details.".formatted(result.reportFile()), 1);
        }
    }

    protected void validateAndConstructArgs() {
        this.config = this.configBuilder().build();
        this.flags = this.options.toFlags();
    }

    protected Config.Builder configBuilder() {
        return this.createPrefilledConfigBuilder();
    }

    /*
     * Exception decompiling
     */
    protected ConsistencyCheckService.Result checkWith(Config config, MemoryTracker memoryTracker) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CheckDatabase.Source toSource(SchemeFileSystemAbstraction fileSystem) throws IOException {
        if (this.sourceOptions == null) {
            return new CheckDatabase.Source.DataTxnSource(this.config);
        }
        if (this.sourceOptions.fromAndTemp == null) {
            return this.sourceOptions.toDataTxnSource();
        }
        return this.sourceOptions.toPathSource(fileSystem);
    }

    private static void checkDbState(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config additionalConfiguration, MemoryTracker memoryTracker) {
        if (CheckCommand.checkRecoveryState(fs, databaseLayout, additionalConfiguration, memoryTracker)) {
            throw new CommandFailedException("Active logical log detected, this might be a source of inconsistencies.\nPlease recover database before running the consistency check.\nTo perform recovery please start database and perform clean shutdown.", 1);
        }
    }

    private static boolean checkRecoveryState(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config additionalConfiguration, MemoryTracker memoryTracker) {
        try {
            return Recovery.isRecoveryRequired((FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout, (Config)additionalConfiguration, (MemoryTracker)memoryTracker);
        }
        catch (Exception e) {
            throw new CommandFailedException("Failure when checking for recovery state: " + e.getMessage(), (Throwable)e, 74);
        }
    }

    private static final class SourceOptions {
        @CommandLine.ArgGroup(exclusive=false)
        private PathOptions.SourceOptions sourceOptions;
        @CommandLine.ArgGroup(exclusive=false)
        private FromAndTemp fromAndTemp;

        private SourceOptions() {
        }

        private CheckDatabase.Source.PathSource toPathSource(SchemeFileSystemAbstraction fs) throws IOException {
            Path fromPath = fs.resolve(this.fromAndTemp.fromPath).toAbsolutePath().normalize();
            if (fromPath instanceof StoragePath && this.fromAndTemp.tempPath == null) {
                throw new IOException("Unable to check a cloud storage-based backup without a temporary path to unpack it into first");
            }
            Path tempPath = this.fromAndTemp.tempPath == null ? fromPath : this.fromAndTemp.tempPath.toAbsolutePath().normalize();
            return new CheckDatabase.Source.PathSource(fromPath, tempPath);
        }

        private CheckDatabase.Source.DataTxnSource toDataTxnSource() {
            return new CheckDatabase.Source.DataTxnSource(this.sourceOptions.dataPath(), this.sourceOptions.txnPath());
        }

        private static final class FromAndTemp {
            @CommandLine.Option(names={"--from-path"}, paramLabel="<path>", required=true, description={"Path to the directory containing dump/backup artifacts that need to be checked for consistency. If the directory contains multiple backups, it will select the most recent backup chain, based on the transaction IDs found, to perform the consistency check. "})
            private String fromPath;
            @CommandLine.Option(names={"--temp-path"}, paramLabel="<path>", showDefaultValue=CommandLine.Help.Visibility.NEVER, description={"Path to directory to be used as a staging area to extract dump/backup artifacts, if needed.%n  Default:  <from-path>"})
            private Path tempPath;

            private FromAndTemp() {
            }
        }
    }
}

