/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Name {
    private static final Predicate<String> NAME_VALIDATOR = Pattern.compile("^\\w+(\\.\\w+)*$").asMatchPredicate();
    private static final String SINGLE_ENTRY_PATTERN = "\\w{0,}";
    private static final String MULTIPLE_ENTRY_PATTERN = "(\\w{0,}(\\.)?){0,}";
    private static final String SEPARATOR = ".";
    private final String fullName;

    private Name(String fullName) {
        this.fullName = Name.validateName(Objects.requireNonNull(fullName));
    }

    public String fullName() {
        return this.fullName;
    }

    public Name child(String name) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.contains((CharSequence)name, (CharSequence)SEPARATOR)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid name", name));
        }
        if (StringUtils.isBlank((CharSequence)this.fullName)) {
            return new Name(name);
        }
        return new Name(this.fullName + SEPARATOR + Objects.requireNonNull(name));
    }

    public boolean isIn(String namespace) {
        String validated = Name.validateName(namespace);
        if (StringUtils.isBlank((CharSequence)validated) || validated.equals(this.fullName)) {
            return true;
        }
        return this.fullName.startsWith(validated + SEPARATOR);
    }

    public boolean isIn(Name name) {
        return this.isIn(name.fullName);
    }

    public boolean matches(String pattern) {
        String transformed = pattern.replace(SEPARATOR, "\\.").replace("**", MULTIPLE_ENTRY_PATTERN).replace("*", SINGLE_ENTRY_PATTERN);
        return Pattern.matches(transformed, this.fullName);
    }

    public boolean matches(List<String> patterns) {
        return patterns.stream().anyMatch(this::matches);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name other = (Name)o;
        return this.fullName.equals(other.fullName);
    }

    public int hashCode() {
        return Objects.hash(this.fullName);
    }

    public String toString() {
        return this.fullName;
    }

    private static String validateName(String fullName) {
        if (StringUtils.isEmpty((CharSequence)fullName)) {
            return fullName;
        }
        boolean valid = NAME_VALIDATOR.test(fullName);
        if (!valid) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid name.", fullName));
        }
        return fullName;
    }

    public static Name of(String name) {
        return new Name(name);
    }
}

